ORCA/M Asm65816 2.1.0

0001 C24A                       title ' Scaling' 
0002 C24A              **********************************************************************
0003 C24A              *
0004 C24A              *                   SCALING
0005 C24A              *
0006 C24A              **********************************************************************
0007 C24A
0008 C24A
0009 C24A              **********************************************************************
0010 C24A              *
0011 C24A              *                   Copyright (C) 1987-1988
0012 C24A              *                   All Rights Reserved
0013 C24A              *                   Apple Computer, Inc.
0014 C24A              *
0015 C24A              **********************************************************************
0016 C24A
0017 C24A              **********************************************************************
0018 C24A              *
0019 C24A              * This file contains the code that is used to derive a font of
0020 C24A              * a given size.
0021 C24A              *
0022 C24A              * NOTES FOR SCALING:
0023 C24A              *
0024 C24A              * (1)  strikePtr is the base address of the source bitmap
0025 C24A              * (2)  rowBytes is its width in bytes (always even)
0026 C24A              * (3)  temp is the starting column of the source rectangle
0027 C24A              *      (where the first column is numbered 0)
0028 C24A              * (4)  imWidth is the width of the source rectangle in pixels
0029 C24A              *       (a single-pixel character would have imWidth = 1)
0030 C24A              * (5)  chHeight is the source font height
0031 C24A              *      (a single-row font would have chHeight = 1)
0032 C24A              *
0033 C24A              * (6)  nStrikePtr, newRowBytes, currPixel, newImWidth, and newChHeight
0034 C24A              *      are the corresponding values for the destination
0035 C24A              *
0036 C24A              * (7)  the point size of the source font is mBestSize, and of the
0037 C24A              *      destination font mWantSize, so we want to scale by
0038 C24A              *      mWantSize/mBestSize. This ratio has been computed once (using
0039 C24A              *      integer disvision); the results are in quotient and remainder.
0040 C24A              *      (There is also a table of multiples of the ratio, rounded up
0041 C24A              *      to the nearest integer; the table only covers very small values
0042 C24A              *      but we can make it larger if we want to.)
0043 C24A              *
0044 C24A              * 
0045 C24A              * Warning:
0046 C24A              *
0047 C24A              * This file contains many equates that are found elsewhere in the system.
0048 C24A              *
0049 C24A              *
0050 C24A              * Entry Points
0051 C24A              *
0052 C24A              *                   ScaleFont
0053 C24A              *
0054 C24A              * Change History
0055 C24A              *
0056 C24A              * xx Jan 87         Bennet Marks
0057 C24A              *
0058 C24A              * Original Code by Bennet Marks using the scaling algorithms 
0059 C24A              * developed by Art Cabral.
0060 C24A              *
0061 C24A              * Spring 88         Steven Glass
0062 C24A              *
0063 C24A              * Code modified to be built with MAX.
0064 C24A              *
0065 C24A              * 11 Jun 88         Steven Glass
0066 C24A              *
0067 C24A              * Modified code to work in ROM.
0068 C24A              *
0069 C24A              * 04 Oct 88         Sue Dumont
0070 C24A              *
0071 C24A              * Added new field to Apple IIGS font header in order to support larger
0072 C24A              * fonts.  This field is the high word of the offset to the offset/width table,
0073 C24A              * "highOwTLoc".  The IIGS font header is now 14 bytes long.
0074 C24A              * NOTE: the offset still remains relative to the low word position of the offset.
0075 C24A              *
0076 C24A              *
0077 C24A              * 10 Apr 89         Steven Glass
0078 C24A              *
0079 C24A              * Change font version from 102 to 105 to make graphics studio work.
0080 C24A              *
0081 C24A              **********************************************************************
0082 C24A
0083 C24A
0084 C24A                       include 'm16.util' 
0085 C24A                       include 'm16.locator' 
0086 C24A                       include 'm16.memory' 
0087 C24A                       include 'm16.intmath' 
0088 C24A                       include 'm16.quickdraw' 
0089 C24A
0090 C24A                       include 'special.macros' 
0091 C24A
0092 C24A
0093 C24A
0094 C24A                       title ' QuickDraw Equates' 
0095 C24A
0096 C24A              ;
0097 C24A              ; These are the QuickDraw E1Vectors
0098 C24A              ;
0099 C24A
0100 C24A              ToSlab   equ   $E01E00
0101 C24A              ToSlice  equ   $E01E00
0102 C24A              ToStuffBig equ   $E01E00
0103 C24A
0104 C24A              StdText  equ   $E01E04
0105 C24A              StdLine  equ   StdText+4
0106 C24A              StdRect  equ   StdLine+4
0107 C24A              StdRRect equ   StdRect+4
0108 C24A              StdOval  equ   StdRRect+4
0109 C24A              StdArc   equ   StdOval+4
0110 C24A              StdPoly  equ   StdArc+4
0111 C24A              StdRgn   equ   StdPoly+4
0112 C24A              StdPixels equ   StdRgn+4
0113 C24A              StdComment equ   StdPixels+4
0114 C24A              StdTxMeas equ   StdComment+4
0115 C24A              StdTxBnds equ   StdTxMeas+4
0116 C24A              StdGetPic equ   StdTxBnds+4
0117 C24A              StdPutPic equ   StdGetPic+4
0118 C24A
0119 C24A
0120 C24A              PortLoc2ZP equ   StdPutPic+4
0121 C24A              UserPat2ZP equ   PortLoc2ZP+4
0122 C24A              GetPenPReady equ   UserPat2ZP+4
0123 C24A              GetBackPReady equ   GetPenPReady+4
0124 C24A              Pen2ZP   equ   GetBackPReady+4
0125 C24A              Back2ZP  equ   Pen2ZP+4
0126 C24A              RotatePat equ   Back2ZP+4
0127 C24A              GetMaskReady equ   RotatePat+4
0128 C24A              Mask2ZP  equ   GetMaskReady+4
0129 C24A              ExpandMask equ   Mask2ZP+4
0130 C24A              RotateMask equ   ExpandMask+4
0131 C24A              RotateLong equ   RotateMask+4
0132 C24A              PreDraw  equ   RotateLong+4
0133 C24A              XSetup   equ   PreDraw+4
0134 C24A
0135 C24A              DrawRectB equ   XSetup+4
0136 C24A              DrawRect equ   DrawRectB+4
0137 C24A              SliceSetup equ   DrawRect+4
0138 C24A              vShiftStay equ   SliceSetup+4           ; these are not used internally!
0139 C24A              vXShiftStay equ   VShiftStay+4          ; things down.  They are provide
0140 C24A              vShiftOut equ   vXShiftStay+4
0141 C24A              vXShiftOut equ   VShiftOut+4
0142 C24A
0143 C24A              BMakeMinRect equ   vXShiftOut+4
0144 C24A              MakeMinRect equ   BMakeMinRect+4
0145 C24A              ShieldCursor equ   MakeMinRect+4
0146 C24A              UnShieldCursor equ   ShieldCursor+4
0147 C24A              SetUpPortRegions equ   UnShieldCursor+4
0148 C24A              SetUpScanPtrs equ   SetUpPortRegions+4
0149 C24A              FreePortRegions equ   SetUpScanPtrs+4
0150 C24A              Free1Region equ   FreePortRegions+4
0151 C24A              Free2Regions equ   Free1Region+4
0152 C24A              Free3Regions equ   Free2Regions+4
0153 C24A              UnlockBufferHandle equ   Free3Regions+4
0154 C24A              Init1Region equ   UnlockBufferHandle+4
0155 C24A              Init2Regions equ   Init1Region+4
0156 C24A              Init3Regions equ   Init2Regions+4
0157 C24A              Seek1Region equ   Init3Regions+4
0158 C24A              Seek2Regions equ   Seek1Region+4
0159 C24A              Seek3Regions equ   Seek2Regions+4
0160 C24A              InitRgn  equ   Seek3Regions+4
0161 C24A              SeekRgn  equ   InitRgn+4
0162 C24A              Join1Buffer equ   SeekRgn+4
0163 C24A              Join2Buffers equ   Join1Buffer+4
0164 C24A              Join3Buffers equ   Join2Buffers+4
0165 C24A
0166 C24A              SetSlabAdr equ   Join3Buffers+4
0167 C24A              SetSliceAdr equ   SetSlabAdr+4
0168 C24A              SetStuffAdr equ   SetSliceAdr+4
0169 C24A
0170 C24A
0171 C24A              BlowItUp equ   SetStuffAdr+4
0172 C24A
0173 C24A              PutPictStuff equ   BlowItUp+4
0174 C24A              AddToPoly equ   PutPictStuff+4
0175 C24A
0176 C24A              OpenPicture equ   AddToPoly+4
0177 C24A              PicComment equ   OpenPicture+4
0178 C24A              ClosePicture equ   PicComment+4
0179 C24A              DrawPicture equ   ClosePicture+4
0180 C24A              KillPicture equ   DrawPicture+4
0181 C24A
0182 C24A              GimmeVersion equ   KillPicture+4
0183 C24A
0184 C24A              v_FrRgn  equ   GimmeVersion+4
0185 C24A              v_PRgn   equ   v_FrRgn+4
0186 C24A              v_ERgn   equ   v_PRgn+4
0187 C24A              v_IRgn   equ   v_ERgn+4
0188 C24A              v_FRgn   equ   v_IRgn+4
0189 C24A              v_FrRect equ   v_FRgn+4
0190 C24A              v_PRect  equ   v_FrRect+4
0191 C24A              v_ERect  equ   v_PRect+4
0192 C24A              v_IRect  equ   v_ERect+4
0193 C24A              v_FRect  equ   v_IRect+4
0194 C24A
0195 C24A
0196 C24A              DChar    equ   v_FRect+4
0197 C24A              DText    equ   DChar+4
0198 C24A              DCString equ   DText                    ; always the same
0199 C24A              BChar    equ   DText+4
0200 C24A              BText    equ   BChar+4
0201 C24A              BCString equ   BText                    ; always the same
0202 C24A              ValidChar equ   BText+4
0203 C24A              GetNextChar equ   ValidChar+4
0204 C24A              CalcDrawStatus equ   GetNextChar+4
0205 C24A              TextAndMinRect equ   CalcDrawStatus+4
0206 C24A              CalcTextBounds equ   TextAndMinRect+4
0207 C24A              SetUpFontInfo equ   CalcTextBounds+4
0208 C24A              SetUpBufInfo equ   SetUpFontInfo+4
0209 C24A              GetTextHandle equ   SetUpBufInfo+4
0210 C24A              ClearBufPart equ   GetTextHandle+4
0211 C24A              PutChar  equ   ClearBufPart+4
0212 C24A              BumpPen  equ   PutChar+4
0213 C24A              CleanUpBuffer equ   BumpPen+4
0214 C24A
0215 C24A
0216 C24A              PutLine  equ   CleanUpBuffer+4
0217 C24A              PutRgn   equ   PutLine+4
0218 C24A              PutRect  equ   PutRgn+4
0219 C24A              CullPoints equ   PutRect+4
0220 C24A              SortPoints equ   CullPoints+4
0221 C24A              PackRgn  equ   SortPoints+4
0222 C24A              RgnOp    equ   PackRgn+4
0223 C24A
0224 C24A              PutOval  equ   RgnOp+4
0225 C24A              BumpOval equ   PutOval+4
0226 C24A              InitOval equ   BumpOval+4
0227 C24A
0228 C24A              SetTB    equ   InitOval+4
0229 C24A              ResetTB  equ   SetTB+4
0230 C24A
0231 C24A              StyleText equ   ResetTB+4
0232 C24A              StyleExtents equ   StyleText+4
0233 C24A              DoBold   equ   StyleExtents+4
0234 C24A              DoUnderLine equ   DoBold+4
0235 C24A
0236 C24A              StdConic equ   DoUnderLine+4            ; vectors added for new ROM
0237 C24A              vDrawConic equ   StdConic+4             ; 22 Aug 86 SEG
0238 C24A              vSetScaleAndMap equ   vDrawConic+4
0239 C24A              DrawCursor equ   vSetScaleAndMap+4
0240 C24A              UndrawCursor equ   DrawCursor+4
0241 C24A              vAngleFromSlope equ   UndrawCursor+4
0242 C24A              vSlopeFromAngle equ   vAngleFromSlope+4
0243 C24A
0244 C24A              RgnBlt   equ   vSlopeFromAngle+4        ; vectors added for CopyPixels
0245 C24A              SharedMRSetup equ   RgnBlt+4            ; 21 Nov 86 SEG
0246 C24A              ShareShieldStuff equ   SharedMRSetup+4
0247 C24A
0248 C24A
0249 C24A                       title ' Font Equates' 
0250 C24A              ;
0251 C24A              ; These are the offsets used to get into fonts
0252 C24A              ;
0253 C24A              O_V      equ   0                        ;vertical coordinate of point
0254 C24A              O_H      equ   2                        ;horizontal
0255 C24A              O_V1     equ   0                        ;rectangle upper left vertical coord.
0256 C24A              O_H1     equ   2                        ;rect. UL horizontal
0257 C24A              O_V2     equ   4                        ;rect. lower right vertical coord.
0258 C24A              O_H2     equ   6                        ;rect. LR horizontal
0259 C24A              O_portInfo equ   0                      ;portInfo in grafPort
0260 C24A              O_boundsRect equ   8                    ;boundsRect in portInfo
0261 C24A              O_font   equ   116                      ;font handle in grafport
0262 C24A              ;
0263 C24A              O_fontStyle equ   4
0264 C24A              O_fontID equ   2
0265 C24A              O_style  equ   4
0266 C24A              O_size   equ   6
0267 C24A              O_version equ   8
0268 C24A              O_fbrExtent equ   10                    ;fbrExtent offset
0269 C24A              O_highOwTLoc equ   12                   ;high word to offset/width table (4 Oct 88)
0270 C24A              ;
0271 C24A              FFormat  equ   0                        ;fontType
0272 C24A              FMinChar equ   2                        ;firstChar
0273 C24A              FMaxChar equ   4                        ;lastChar
0274 C24A              FMaxWd   equ   6                        ;widMax
0275 C24A              FBBOX    equ   8                        ;kernMax
0276 C24A              FBBOY    equ   10                       ;nDescent
0277 C24A              FBBDX    equ   12                       ;fRectMax
0278 C24A              FBBDY    equ   14                       ;chHeight
0279 C24A              FLength  equ   16                       ;owTLoc
0280 C24A              FAscent  equ   18                       ;ascent
0281 C24A              FDescent equ   20                       ;descent
0282 C24A              FLeading equ   22                       ;leading
0283 C24A              FRaster  equ   24                       ;rowWords
0284 C24A              ;and some of our own devising
0285 C24A              FStrike  equ   26                       ;font strike
0286 C24A              ;offset/width table entry indicating an in-range missing symbol:
0287 C24A              owMSVal  equ   -1
0288 C24A              ;
0289 C24A              ;
0290 C24A              ;    Font Lore offsets
0291 C24A              o_FontVersion equ   8
0292 C24A              o_FamNum equ   2
0293 C24A              ;
0294 C24A              o_FLFamNum equ   0
0295 C24A              o_FLStyle equ   2
0296 C24A              o_FLSize equ   4
0297 C24A              o_FLVersion equ   6
0298 C24A              o_FLMaxWid equ   8
0299 C24A              o_FLFBRXtnt equ   10
0300 C24A              o_FLHighOffset equ   12                 ;high word of offset to offset/width table
0301 C24A              ;                                       ;SMD - 4 Oct 88
0302 C24A              ;
0303 C24A              ;                copy fscons
0304 C24A              ;
0305 C24A              ;word breakdown constants
0306 C24A              bitsInWord equ   16
0307 C24A              allBitsOff equ   %0000000000000000
0308 C24A              allBitsOn equ   %1111111111111111
0309 C24A              firstBit equ   %1000000000000000
0310 C24A              firstBitXBAed equ   %0000000010000000
0311 C24A              lastBit  equ   %0000000000000001
0312 C24A              lastBitXBAed equ   %0000000100000000
0313 C24A              first12Bits equ   %1111111111110000
0314 C24A              last4Bits equ   %0000000000001111
0315 C24A              first13Bits equ   %1111111111111000
0316 C24A              first14Bits equ   %1111111111111100
0317 C24A              first15Bits equ   %1111111111111110
0318 C24A              lowByte  equ   $00FF
0319 C24A              highByte equ   $FF00
0320 C24A              last15Bits equ   %0111111111111111
0321 C24A              ;
0322 C24A              ourFHOS  equ   12                       ;offset to Mac part of font
0323 C24A              ;                                       ;(for font version 01.01, in bytes)
0324 C24A              ;also called:
0325 C24A              ourHeadLength equ   ourFHOS
0326 C24A              OurVersion equ   $0101                  ;font version number matching this code
0327 C24A              ;
0328 C24A              MHLength equ   26                       ;Mac header length (bytes)
0329 C24A              ;also called:
0330 C24A              macHeadLength equ   MHLength
0331 C24A              ;
0332 C24A              ******
0333 C24A              * SMD - Version 1.02 equates.  Apple IIGS font header now has an additional
0334 C24A              *       field, "highOwTLoc", the high word of the offset to the offset/width
0335 C24A              *       table.
0336 C24A              *
0337 C24A              *
0338 C24A              * To make graphics studio work we change this version number from 102 to 105.
0339 C24A              *
0340 C24A              * SEG 10 Apr 89
0341 C24A              *
0342 C24A              NewVersion equ   $0105                  ;new version for scaling fonts   10 Oct 88
0343 C24A              newFHOS  equ   14                       ;offset to Mac font record (Version 1.02)
0344 C24A              newHeadLength equ   newFHOS             ;(4 Oct 88)
0345 C24A              *
0346 C24A              ******
0347 C24A              scaleSizeErr equ   $1B0C                ;must match Font Manager
0348 C24A
0349 C24A
0350 C24A                       title ' Direct Page Equates' 
0351 C24A
0352 C24A              ******************************
0353 C24A              *                            *
0354 C24A              *  June 15, 1987  3:00 pm    *
0355 C24A              *  BHM  x6245                *
0356 C24A              *                            *
0357 C24A              ******************************
0358 C24A              ;
0359 C24A              ******************************************************************************
0360 C24A              *
0361 C24A              *  These are the 0-page locations used by the font-scaling shell.  They lie
0362 C24A              *  on QD II's 3rd 0-page
0363 C24A              *
0364 C24A              ******************************************************************************
0365 C24A              ;
0366 C24A              mPortRef equ   0
0367 C24A              fontHandle equ   mPortRef+4             ;added 6/15/87 - BHM
0368 C24A              fontHeadPtr equ   fontHandle+4
0369 C24A              fontRecPtr equ   fontHeadPtr+4
0370 C24A              strikePtr equ   fontRecPtr+4
0371 C24A              owTPtr   equ   strikePtr+4
0372 C24A              locTPtr  equ   owTPtr+4
0373 C24A              ;
0374 C24A              nFontHandle equ   locTPtr+4
0375 C24A              nFontHeadPtr equ   nFontHandle+4
0376 C24A              nFontRecPtr equ   nFontHeadPtr+4
0377 C24A              nStrikePtr equ   nFontRecPtr+4
0378 C24A              nOWTPtr  equ   nStrikePtr+4
0379 C24A              nLocTPtr equ   nOWTPtr+4
0380 C24A              ;
0381 C24A              sbHandle equ   nLocTPtr+4
0382 C24A              scaledBytesPtr equ   sbHandle+4
0383 C24A              flbHandle equ   scaledBytesPtr+4
0384 C24A              fontLorePtr equ   flbHandle+4
0385 C24A              ;
0386 C24A              temp     equ   fontLorePtr+4
0387 C24A              ;
0388 C24A              firstChar equ   temp+4
0389 C24A              lastChar equ   firstChar+2
0390 C24A              chHeight equ   lastChar+2
0391 C24A              tableLength equ   chHeight+2            	;length of Location table, in bytes
0392 C24A              owTOffset equ   tableLength+2
0393 C24A              hiOwTOffset equ   owTOffset+2           	;SMD- added 4 Oct 88
0394 C24A              newFontSize equ   hiOwTOffset+2
0395 C24A              newAscent equ   newFontSize+2
0396 C24A              newDescent equ   newAscent+2
0397 C24A              newChHeight equ   newDescent+2
0398 C24A              rowBytes equ   newChHeight+2
0399 C24A              newRowBytes equ   rowBytes+2
0400 C24A              newStrikeSize equ   newRowBytes+2       	;4 Oct 88 - now a long
0401 C24A              currIndex equ   newStrikeSize+4
0402 C24A              lastIndex equ   currIndex+2
0403 C24A              currPixel equ   lastIndex+2
0404 C24A              ImWidth  equ   currPixel+2
0405 C24A              newImWidth equ   ImWidth+2
0406 C24A              quotient equ   newImWidth+2
0407 C24A              remainder equ   quotient+2
0408 C24A              bucket   equ   remainder+2
0409 C24A              lastQuo  equ   bucket+2
0410 C24A              maxB     equ   lastQuo+2
0411 C24A              lastSBIndex equ   maxB+2
0412 C24A              ;
0413 C24A              mWantSize equ   lastSBIndex+2
0414 C24A              mBestSize equ   mWantSize+2
0415 C24A              mUserID  equ   mBestSize+2
0416 C24A              EndOfFSZP1 equ   mUserID+2
0417 C24A              ;
0418 C24A              * These variables are all kept on the third zero page.
0419 C24A
0420 C24A              SrcVSize equ   ChHeight
0421 C24A              SrcHSize equ   ImWidth
0422 C24A              DstVSize equ   NewChHeight
0423 C24A              DstHSize equ   NewImWidth
0424 C24A              SrcLeft  equ   Temp
0425 C24A              DstLeft  equ   CurrPixel
0426 C24A              SrcBase  equ   StrikePtr
0427 C24A              SrcWidth equ   Rowbytes
0428 C24A              DstBase  equ   nStrikePtr
0429 C24A              DstWidth equ   NewRowbytes
0430 C24A
0431 C24A              VError   equ   EndOfFSZP1
0432 C24A              HError   equ   VError+2
0433 C24A              ScratchHandle equ   HError+2
0434 C24A              SrcLimit equ   ScratchHandle+4
0435 C24A
0436 C24A              DstLimit equ   SrcLimit+4
0437 C24A              DestNibble equ   DstLimit+2
0438 C24A              LastNibble equ   DestNibble+2
0439 C24A              ByteLimit equ   LastNibble+2
0440 C24A              NextFlag equ   ByteLimit+2
0441 C24A              LoNib    equ   NextFlag+2
0442 C24A              Nibs     equ   LoNib+2
0443 C24A              NextNib  equ   Nibs+2
0444 C24A              SrcCtr   equ   NextNib+2
0445 C24A              SrcBuf   equ   SrcCtr+2
0446 C24A              DstBuf   equ   SrcBuf+4
0447 C24A              HInc     equ   DstBuf+4
0448 C24A              SrcPtr   equ   HInc+2
0449 C24A              DstPtr   equ   SrcPtr+4
0450 C24A              LastOut  equ   DstPtr+4
0451 C24A              ThisOut  equ   LastOut+2
0452 C24A              ThisWord equ   ThisOut+2
0453 C24A              HowFarToShift equ   ThisWord+2
0454 C24A              LeftMask equ   HowFarToShift+2
0455 C24A              RightMask equ   LeftMask+2
0456 C24A              RightPos equ   RightMask+2
0457 C24A              DstRightMask equ   RightPos+2
0458 C24A              DstRightPos equ   DstRightMask+2
0459 C24A              ;
0460 C24A              ;added 1/19/87 10:30 am:
0461 C24A              SrcBufSize equ   DstRightPos+2
0462 C24A              DstBufSize equ   SrcBufSize+2
0463 C24A              DstY     equ   DstBufSize+2
0464 C24A              DstCtr   equ   DstY+2
0465 C24A              DstCnt   equ   DstCtr+2
0466 C24A              SrcVal   equ   DstCnt+2
0467 C24A              SrcWord  equ   SrcVal+2
0468 C24A              SrcCnt   equ   SrcWord+2
0469 C24A              DstWord  equ   SrcCnt+2
0470 C24A              DstWords equ   DstWord+2
0471 C24A              DstRight equ   DstWords+2
0472 C24A
0473 C24A              ;
0474 C24A              ; New direct page location Added 11 Jun 88
0475 C24A              ;
0476 C24A              ActionIndex equ   DstRight+2
0477 C24A
0478 C24A              ;
0479 C24A              ; New equates added 11 Jun 88
0480 C24A              ;
0481 C24A              CopyIndex equ   0
0482 C24A              ShiftIndex equ   2
0483 C24A              StretchIndex equ   4
0484 C24A              ShrinkIndex equ   6
0485 C24A
0486 C24A
0487 C24A
0488 C24A
0489 C24A              ;
0490 C24A              ******************************************************************************
0491 C24A              *
0492 C24A              *  The next 0-page locations live on other 0-pages - the Font Manager's, and
0493 C24A              *  QD II's 1st.  They are hard-coded to avoid including all their 0-page
0494 C24A              *  locations (including some name collisions with the Font Scaler stuff).
0495 C24A              *  Maintainers Beware!
0496 C24A              *
0497 C24A              ******************************************************************************
0498 C24A              ;
0499 C24A              UserID   equ   $0A                      ;QD II's 1st 0-page
0500 C24A              PortRef  equ   $24                      ;QD II's 1st 0-page
0501 C24A              ;
0502 C24A              BestSize equ   $8E                      ;FM's 0-page
0503 C24A              WantSize equ   $96                      ;FM's 0-page
0504 C24A              ;
0505 C24A
0506 C24A
0507 C24A
0508 C24A
0509 C24A                       title ' Forward References' 
0510 C24A              ;-----------------------------------------------
0511 C24A              ;
0512 C24A              ;   Forward address and entries
0513 C24A              ;
0514 C24A              ;-----------------------------------------------
0515 C24A
0516 C24A                       ENTRY CleanUpScaling
0517 C24A                       ENTRY ToAction
0518 C24A
0519 C24A                       ENTRY ShrinkText
0520 C24A                       ENTRY StretchText
0521 C24A                       ENTRY ShiftText
0522 C24A                       ENTRY CopyText
0523 C24A                       ENTRY ToMerge
0524 C24A                       ENTRY SetupScaling
0525 C24A                       ENTRY ScaleBits
0526 C24A                       ENTRY ScaleByte
0527 C24A                       ENTRY TablesNStrike
0528 C24A                       ENTRY ClearNewStrike
0529 C24A                       ENTRY SetNewHdrVals
0530 C24A                       ENTRY CalcNewFntPtrs
0531 C24A                       ENTRY CalcNewFntSz
0532 C24A                       ENTRY InitScaling
0533 C24A                       ENTRY InitByteScaler
0534 C24A                       ENTRY SetUp2Bufs
0535 C24A                       ENTRY CalcFontPtrs
0536 C24A                       ENTRY FntMgr2FntSclr
0537 C24A
0538 C24A
0539 C24A                       title ' Scale Font' 
0540 C24A              ****************************************************************
0541 C24A              *
0542 C24A              ScaleFont PROC EXPORT 
0543 C24A              *
0544 C24A              *
0545 C24A              *  This subroutine scales the current font by the scale factor      
0546 C24A              *  wantSize/bestSize.  The handle for the new font is left in x,a.  
0547 C24A              *
0548 C24A              *  If a memory error is encountered during the scaling process,     
0549 C24A              *  then the routine returns with the carry set and the error code   
0550 C24A              *  in the acc.  Otherwise it returns with the carry clear.
0551 C24A              *
0552 C24A              *  In its present form, the code has been written more for clarity  
0553 C24A              *  than for speed; little optimizing has been done.  Next pass,     
0554 C24A              *  people.
0555 C24A              *
0556 C24A              *  For convenience with use by the Font Manager, ScaleFont (and in
0557 C24A              *  particular FntMgr2FntSclr) expects to find the desired size in
0558 C24A              *  y, the userID in the acc., and the current (best-so-far) size in
0559 C24A              *  x (that last could be picked up from the font itself, but why
0560 C24A              *  mess around?)
0561 C24A              *
0562 C24A              *
0563 C24A              *
0564 C24A              * Inputs:
0565 C24A              *                   on direct page
0566 C24A              *
0567 C24A              * Outputs:
0568 C24A              *                   a-reg   Low word of font handle (or error code)
0569 C24A              *                   x-reg   high word of font handle
0570 C24A              *                   carry   set if error, clear if no error
0571 C24A              *
0572 C24A              * External Refs:
0573 C24A              *                   lots
0574 C24A              *
0575 C24A              * Entry Points:
0576 C24A              *                   none
0577 C24A              *
0578 C24A                       longa on                       ; mode
0579 C24A                       longi on
0580 C24A              *
0581 C24A              *
0582 C24A              * Change History
0583 C24A              *
0584 C24A              * 14 Jan 87         Bennet Marks
0585 C24A              *
0586 C24A              * Started
0587 C24A              *
0588 C24A              * 15 Jun 87         Bennet Marks
0589 C24A              *
0590 C24A              * Last Modified
0591 C24A              *
0592 C24A              ****************************************************************
0593 C24A
0594 C24A              ;
0595 C24A              ;
0596 C24A 0B                    phd   
0597 C24B              ;
0598 C24B 22 71 C7 FC           jsl   FntMgr2FntSclr
0599 C24F              ;
0600 C24F 22 44 C3 FC           jsl   CalcFontPtrs
0601 C253              ;
0602 C253 22 90 C3 FC           jsl   SetUp2Bufs
0603 C257 90 05                 bcc   NoErr1
0604 C259 85 44                 sta   temp
0605 C25B 82 98 00              brl   Error1
0606 C25E              ;
0607 C25E              NoErr1                                  ;
0608 C25E              ;----------------------------------------------------------
0609 C25E              ;
0610 C25E              ; I init the byte scaler first because InitScaling makes
0611 C25E              ; calls to ScaleByte.
0612 C25E              ;
0613 C25E 22 24 C7 FC           jsl   InitByteScaler
0614 C262              ;
0615 C262 22 A2 C7 FC           jsl   InitScaling
0616 C266              ****
0617 C266              *
0618 C266              *  some error handling added here - BHM 6/15/87
0619 C266              *
0620 C266              ****
0621 C266 90 04                 bcc   NoErr2
0622 C268 85 44                 sta   temp
0623 C26A 80 70                 bra   Error2
0624 C26C              ;
0625 C26C              NoErr2                                  ;
0626 C26C 22 7F C4 FC           jsl   CalcNewFntSz
0627 C270              ;
0628 C270 90 04                 bcc   NoErr3
0629 C272 85 44                 sta   temp
0630 C274 80 59                 bra   Error3
0631 C276              NoErr3                                  ;
0632 C276 22 57 C5 FC           jsl   CalcNewFntPtrs           ;11 Oct 88 - SMD
0633 C27A 90 04                 bcc   NoErr3a                  ;carry set if a size error occurred.
0634 C27C 85 44                 sta   temp                     ;size error code
0635 C27E 80 42                 bra   Error4
0636 C280              ;
0637 C280 22 A3 C5 FC  NoErr3a  jsl   SetNewHdrVals
0638 C284 90 05                 bcc   NoErr4
0639 C286 85 44                 sta   temp
0640 C288 82 37 00              brl   Error4
0641 C28B              NoErr4                                  ;
0642 C28B 22 80 C6 FC           jsl   ClearNewStrike
0643 C28F              ;
0644 C28F 22 AC C6 FC           jsl   TablesNStrike
0645 C293              ;
0646 C293 A5 3E 48 A5           PushLong <flbHandle 
0647 C299 A2 02 10 22           _DisposeHandle 
0648 C2A0 A5 36 48 A5           PushLong <sbHandle 
0649 C2A6 A2 02 10 22           _DisposeHandle 
0650 C2AD              ;
0651 C2AD 22 D2 C8 FC           jsl   CleanUpScaling
0652 C2B1              ;
0653 C2B1              ;unlock old font:
0654 C2B1 A0 04 00              ldy   #4
0655 C2B4 B7 04                 lda   [fontHandle],y
0656 C2B6 29 FF 7F              and   #$7FFF
0657 C2B9 97 04                 sta   [fontHandle],y
0658 C2BB              ;
0659 C2BB A6 1E                 ldx   nFontHandle+2
0660 C2BD A5 1C                 lda   nFontHandle
0661 C2BF              ;
0662 C2BF 18                    clc                            ;to mark no error
0663 C2C0              ;
0664 C2C0 2B                    pld   
0665 C2C1 6B                    rtl   
0666 C2C2              ;
0667 C2C2              Error4                                  ;
0668 C2C2 A5 1E 48 A5           PushLong <nFontHandle 
0669 C2C8 A2 02 10 22           _DisposeHandle 
0670 C2CF              Error3                                  ;
0671 C2CF A5 86 48 A5           PushLong <ScratchHandle 
0672 C2D5 A2 02 10 22           _DisposeHandle 
0673 C2DC              Error2                                  ;
0674 C2DC A5 3E 48 A5           PushLong <flbHandle 
0675 C2E2 A2 02 10 22           _DisposeHandle 
0676 C2E9 A5 36 48 A5           PushLong <sbHandle 
0677 C2EF A2 02 10 22           _DisposeHandle 
0678 C2F6              Error1                                  ;
0679 C2F6              ;
0680 C2F6              ;unlock old font:
0681 C2F6 A0 04 00              ldy   #4
0682 C2F9 B7 04                 lda   [fontHandle],y
0683 C2FB 29 FF 7F              and   #$7FFF
0684 C2FE 97 04                 sta   [fontHandle],y
0685 C300              ;
0686 C300 A5 44                 lda   temp                     ;error code
0687 C302 38                    sec                            ;signal the error
0688 C303 2B                    pld   
0689 C304 6B                    rtl   
0690 C305                       ENDP 
0691 C305
0692 C305
0693 C305                       EJECT 
0694 C305              *******************************************************************************
0695 C305              *
0696 C305              GetportFontPtr PROC Export 
0697 C305              *
0698 C305              * Description:      This routine derefs the current grafports font handle and
0699 C305              *                   returns the derefed version of it in fontHeadPtr. This should
0700 C305              *                   be called by any routine that wants to look at the font 
0701 C305              *                   record directly. It knows about fast fonts, and it knows how
0702 C305              *                   to use them!
0703 C305              *
0704 C305              * NOTE:
0705 C305              *
0706 C305              *
0707 C305              * Inputs:           NotMuch
0708 C305              *
0709 C305              * Outputs:          FontHeadPtr
0710 C305              *
0711 C305              * External Refs:
0712 C305              ;
0713 C305              ; Equates for the fastfont record
0714 C305              ;
0715 C305              o_FFAscent equ   0
0716 C305              o_FFDescent equ   o_FFAscent+2
0717 C305              o_FFMaxWidth equ   o_FFDescent+2
0718 C305              o_FFLeading equ   o_FFMaxWidth+2
0719 C305              o_FFrowBytes equ   o_FFLeading+2
0720 C305              o_oldFontHandle equ   o_FFRowBytes+2
0721 C305              o_StrikeSize equ   o_oldFontHandle+4
0722 C305              o_FFSizeofVars equ   o_StrikeSize+4
0723 C305              o_FFWidthTable equ   o_FFSizeofVars
0724 C305              o_FFOffsetTable equ   o_FFWidthTable+256
0725 C305              o_FFEndOfTables equ   o_FFOffsetTable+512
0726 C305              ;
0727 C305              *
0728 C305              * Entry Points:
0729 C305              *
0730 C305              *******************************************************************************
0731 C305 A0 76 00              ldy   #(O_font+2)
0732 C308 B7 00                 lda   [mPortRef],y             ;font handle high word
0733 C30A 10 24                 bpl   standardFont             ; if high bit clear we are using a standard font
0734 C30C
0735 C30C              loadStdData  
0736 C30C 85 06                 sta   fontHandle+2             ; get the handle to the fastfont stuff
0737 C30E A0 74 00              ldy   #o_font
0738 C311 B7 00                 lda   [mportRef],y
0739 C313 85 04                 sta   fontHandle
0740 C315 A7 04                 lda   [fontHandle]             ; and deref it...
0741 C317 85 08                 sta   fontHeadPtr
0742 C319 A0 02 00              ldy   #2
0743 C31C B7 04                 lda   [fontHandle],y
0744 C31E 85 0A                 sta   fontHeadPtr+2
0745 C320              ;
0746 C320 A0 0A 00              ldy   #o_oldFontHandle         ; offset to the old font..
0747 C323 B7 08                 lda   [fontHeadPtr],y          ; get the old font handle
0748 C325 85 04                 sta   fontHandle
0749 C327 A0 0C 00              ldy   #o_oldFontHandle+2
0750 C32A B7 08                 lda   [fontHeadPtr],y
0751 C32C 85 06                 sta   fontHandle+2             ; set temp to be the old font handle
0752 C32E 80 08                 bra   SF0010                   ; and branch into standard font stuff
0753 C330
0754 C330              standardFont  
0755 C330 85 06                 sta   fontHandle+2
0756 C332 88                    dey   
0757 C333 88                    dey   
0758 C334 B7 00                 lda   [mPortRef],y
0759 C336 85 04                 sta   fontHandle
0760 C338              ;
0761 C338              SF0010    
0762 C338 A7 04                 lda   [fontHandle]
0763 C33A 85 08                 sta   fontHeadPtr
0764 C33C A0 02 00              ldy   #2
0765 C33F B7 04                 lda   [fontHandle],y
0766 C341 85 0A                 sta   fontHeadPtr+2
0767 C343 6B                    rtl   
0768 C344                       EndP 
0769 C344
0770 C344
0771 C344                       title ' CalcFontPtrs' 
0772 C344              ****************************************************************
0773 C344              *
0774 C344              CalcFontPtrs PROC 
0775 C344              *
0776 C344              *  This subroutine gets the current font handle out of the grafport 
0777 C344              *  and calculates the various pointers associated with it.  It also 
0778 C344              *  saves a few font values that it had to fetch during its calc-    
0779 C344              *  ulations.  (It also sets rowBytes, because there was no better   
0780 C344              *  place to do it.)
0781 C344              *
0782 C344              *
0783 C344              * Inputs:
0784 C344              *                   current graf port
0785 C344              *
0786 C344              * Outputs:
0787 C344              *                   Various font pointers
0788 C344              *                   Font Values
0789 C344              *                   rowBytes
0790 C344              *
0791 C344              * External Refs:
0792 C344              *                   none
0793 C344              *
0794 C344              * Entry Points:
0795 C344              *                   none
0796 C344              *
0797 C344                       longa on                       ; mode
0798 C344                       longi on
0799 C344              *
0800 C344              *
0801 C344              * Change History
0802 C344              *
0803 C344              * 11 Jan 87         Bennet Marks
0804 C344              *
0805 C344              * Started code.
0806 C344              *
0807 C344              * 15 Jun 87         Bennet Marks
0808 C344              *
0809 C344              * Finished first pass.
0810 C344              *
0811 C344              * 04 Oct 88         Sue Dumont
0812 C344              *
0813 C344              * Removed code which calculated the locTable pointer and the offset/width
0814 C344              * table pointer.  This code is now located in the routine "SetUp2Bufs".
0815 C344              * This is done because the high word of the offset to offset/width table
0816 C344              * is retrieved from "_GetFontLore" in "SetUp2Bufs", which is needed to make
0817 C344              * these calculations.
0818 C344              *
0819 C344              * 3/15/89           Mensch
0820 C344              * Added call to getPortFontPtr to make getting around fastfonts easy
0821 C344              ****************************************************************
0822 C344
0823 C344              ;
0824 C344 22 05 C3 FC           jsl   GetportFontPtr
0825 C348              ; was:
0826 C348              ;	ldy	#o_font	;get font handle
0827 C348              ;	lda	[mPortRef],y
0828 C348              ;	sta	fontHandle
0829 C348              ;	iny
0830 C348              ;	iny
0831 C348              ;	lda	[mPortRef],y
0832 C348              ;	sta	fontHandle+2
0833 C348              ;
0834 C348              ;	lda	[fontHandle]	;dereference
0835 C348              ;	sta	fontHeadPtr
0836 C348              ;	ldy	#2
0837 C348              ;	lda	[fontHandle],y
0838 C348              ;	sta	fontHeadPtr+2
0839 C348
0840 C348 A0 04 00              ldy   #4
0841 C34B B7 04                 lda   [fontHandle],y
0842 C34D 09 00 80              ora   #$8000                   ;and lock the font for now...
0843 C350 97 04                 sta   [fontHandle],y
0844 C352              ;
0845 C352 A7 08                 lda   [fontHeadPtr]            ;offset to Mac header part
0846 C354 0A                    asl   a                        ;in bytes
0847 C355 18                    clc   
0848 C356 65 08                 adc   fontHeadPtr
0849 C358 85 0C                 sta   fontRecPtr
0850 C35A A5 0A                 lda   fontHeadPtr+2
0851 C35C 90 01                 bcc   NoCarry1
0852 C35E 1A                    inc   a
0853 C35F              NoCarry1                                ;
0854 C35F 85 0E                 sta   fontRecPtr+2
0855 C361              ;
0856 C361 A0 02 00              ldy   #FMinChar
0857 C364 B7 0C                 lda   [fontRecPtr],y
0858 C366 85 48                 sta   firstChar
0859 C368              ;
0860 C368 A0 04 00              ldy   #FMaxChar
0861 C36B B7 0C                 lda   [fontRecPtr],y
0862 C36D 85 4A                 sta   lastChar
0863 C36F              ;
0864 C36F 1A                    inc   a
0865 C370 1A                    inc   a
0866 C371 1A                    inc   a
0867 C372 38                    sec   
0868 C373 E5 48                 sbc   firstChar
0869 C375 0A                    asl   a
0870 C376 85 4E                 sta   tableLength              ;length of each table
0871 C378              ;
0872 C378 A5 0C                 lda   fontRecPtr
0873 C37A 18                    clc   
0874 C37B 69 1A 00              adc   #FStrike
0875 C37E 85 10                 sta   strikePtr
0876 C380 A5 0E                 lda   fontRecPtr+2
0877 C382 90 01                 bcc   NoCarry2
0878 C384 1A                    inc   a
0879 C385 85 12        NoCarry2 sta   strikePtr+2
0880 C387              ;
0881 C387 A0 18 00              ldy   #FRaster
0882 C38A B7 0C                 lda   [fontRecPtr],y           ;rowWords
0883 C38C 0A                    asl   a                        ;rowBytes
0884 C38D 85 5C                 sta   rowBytes
0885 C38F              ;
0886 C38F 6B                    rtl   
0887 C390                       ENDP 
0888 C390
0889 C390
0890 C390                       title ' SetUp2Bufs' 
0891 C390              ****************************************************************
0892 C390              *
0893 C390              SetUp2Bufs PROC 
0894 C390              *
0895 C390              *  This subroutine gets the buffer needed for a GetFontLore call,   
0896 C390              *  makes that call, figures out the largest byte our byte-scaler    
0897 C390              *  will have to scale (maxB), and gets a buffer of an appropriate   
0898 C390              *  size for the scale results.
0899 C390              *
0900 C390              *  The font lore buffer handle will be flbHandle, and the pointer   
0901 C390              *  fontLorePtr.  The scaled bytes list buffer will have handle      
0902 C390              *  sbHandle, and pointer scaledBytesPtr
0903 C390              *
0904 C390              *  If either memory manager call generates an error, then the       
0905 C390              *  routine will return with the carry set, the error code in the    
0906 C390              *  acc., and neither buffer allocated.  If no error is generated,   
0907 C390              *  SetUp2Bufs returns with carry clear.
0908 C390              *
0909 C390              *
0910 C390              * Inputs:
0911 C390              *                   some direct page values.
0912 C390              *
0913 C390              * Outputs:
0914 C390              *                   flbHandle
0915 C390              *                   fontLorePtr
0916 C390              *                   sbHandle
0917 C390              *                   ScaledBytesPtr
0918 C390              *
0919 C390              * External Refs:
0920 C390              *                   none
0921 C390              *
0922 C390              * Entry Points:
0923 C390              *                   none
0924 C390              *
0925 C390                       longa on                       ; mode
0926 C390                       longi on
0927 C390              *
0928 C390              *
0929 C390              * Change History
0930 C390              *
0931 C390              * 11 Jan 87         Bennet Marks
0932 C390              *
0933 C390              * Coding started.
0934 C390              *
0935 C390              * 14 Jan 87         Bennet Marks
0936 C390              *
0937 C390              * First pass complete.
0938 C390              *
0939 C390              * 04 Oct 88         Sue Dumont
0940 C390              *
0941 C390              * Added code from "CalcFontPtrs" which calculates the locTable pointer
0942 C390              * and the offset/width table pointer.  I also try to retrieve 14 bytes 
0943 C390              * from "_GetFontLore" for the additional field, highOwTLoc.
0944 C390              *
0945 C390              ****************************************************************
0946 C390
0947 C390 48                    pha   
0948 C391 48                    pha   
0949 C392 F4 00 00 F4           PushLong #14                   ;#bytes for font lore rec (Ver 1.02)
0950 C398 D4 7E                 pei   mUserID
0951 C39A F4 00 80              pea   $8000                    ;locked on allocation.
0952 C39D F4 00 00 F4           PushLong #0 
0953 C3A3              ;
0954 C3A3 A2 02 09 22           _NewHandle                     ;allocate memory for IIGS font header record
0955 C3AA              ;
0956 C3AA 90 03                 bcc   NoMemErr1
0957 C3AC              ;mem error:
0958 C3AC FA                    plx   
0959 C3AD FA                    plx   
0960 C3AE 6B                    rtl   
0961 C3AF              ;
0962 C3AF 68           NoMemErr1 pla   
0963 C3B0 85 3C                 sta   flbHandle
0964 C3B2 68                    pla   
0965 C3B3 85 3E                 sta   flbHandle+2
0966 C3B5              ;
0967 C3B5 A7 3C                 lda   [flbHandle]              ;deref
0968 C3B7 85 40                 sta   fontLorePtr
0969 C3B9 A0 02 00              ldy   #2
0970 C3BC B7 3C                 lda   [flbHandle],y
0971 C3BE 85 42                 sta   fontLorePtr+2
0972 C3C0              ;
0973 C3C0 F4 00 00              PushWord #0 
0974 C3C3 A5 42 48 A5           PushLong <fontLorePtr 
0975 C3C9 F4 0E 00              PushWord #14                   ;Apple IIGS font header size
0976 C3CC              ;
0977 C3CC A2 04 D9 22           _GetFontLore 
0978 C3D3              ;
0979 C3D3 68                    pla                            ;check # bytes returned to see if we got the
0980 C3D4 C9 0E 00              cmp   #14                      ;high word offset field (Version 1.02)
0981 C3D7 90 0A                 blt   NoHighOffset
0982 C3D9 A0 0C 00              ldy   #o_FLHighOffset          ;Version 1.02 -  get highOwTLoc field
0983 C3DC B7 40                 lda   [fontLorePtr],y
0984 C3DE 0A                    asl   a                        ;offset in bytes
0985 C3DF 85 52                 sta   hiOwTOffset
0986 C3E1 80 02                 bra   CalcTablePtrs
0987 C3E3
0988 C3E3 64 52        NoHighOffset stz   hiOwTOffset          ;old version, store zero here
0989 C3E5
0990 C3E5              ******
0991 C3E5              * moved code here from "CalcFontPtrs" to calculate table pointers
0992 C3E5              * SMD - 4 Oct 88
0993 C3E5              *
0994 C3E5 A0 10 00     CalcTablePtrs ldy   #FLength            ;low word of offset to offset/width table
0995 C3E8 B7 0C                 lda   [fontRecPtr],y           ;owTLoc (low word)
0996 C3EA 0A                    asl   a                        ;offset in bytes
0997 C3EB 85 50                 sta   owTOffset
0998 C3ED 18                    clc   
0999 C3EE 69 10 00              adc   #FLength
1000 C3F1 65 0C                 adc   fontRecPtr
1001 C3F3 85 14                 sta   owTPtr
1002 C3F5 A5 0E                 lda   fontRecPtr+2
1003 C3F7 65 52                 adc   hiOwTOffset              ;high offset in bytes
1004 C3F9 85 16                 sta   owTPtr+2
1005 C3FB
1006 C3FB A5 14                 lda   owTPtr
1007 C3FD 38                    sec   
1008 C3FE E5 4E                 sbc   tableLength
1009 C400 85 18                 sta   locTPtr
1010 C402 A5 16                 lda   owTPtr+2
1011 C404 B0 01                 bcs   NoBorrow1
1012 C406 3A                    dec   a
1013 C407 85 1A        NoBorrow1 sta   locTPtr+2
1014 C409              *
1015 C409              ******
1016 C409 A0 0A 00              ldy   #o_FLFBRXtnt
1017 C40C B7 40                 lda   [fontLorePtr],y
1018 C40E              ;
1019 C40E A0 12 00              ldy   #FAscent
1020 C411 D7 0C                 cmp   [fontRecPtr],y
1021 C413 10 02                 bpl   MaxOK1
1022 C415 B7 0C                 lda   [fontRecPtr],y
1023 C417              ;
1024 C417 A0 14 00     MaxOK1   ldy   #FDescent
1025 C41A D7 0C                 cmp   [fontRecPtr],y
1026 C41C 10 02                 bpl   MaxOK2
1027 C41E B7 0C                 lda   [fontRecPtr],y
1028 C420              ;
1029 C420 A0 16 00     MaxOK2   ldy   #FLeading
1030 C423 D7 0C                 cmp   [fontRecPtr],y
1031 C425 10 02                 bpl   MaxOK3
1032 C427 B7 0C                 lda   [fontRecPtr],y
1033 C429              ;
1034 C429 A0 0C 00     MaxOK3   ldy   #FBBDX
1035 C42C D7 0C                 cmp   [fontRecPtr],y           ;fRectMax
1036 C42E 10 02                 bpl   MaxOK4
1037 C430 B7 0C                 lda   [fontRecPtr],y
1038 C432              ;
1039 C432 85 76        MaxOK4   sta   maxB                     ;biggest number we need to scale
1040 C434              ;
1041 C434 48                    pha   
1042 C435 48                    pha   
1043 C436 F4 00 00              pea   0
1044 C439 A5 76                 lda   maxB
1045 C43B 1A                    inc   a                        ;for 0 entry
1046 C43C 1A                    inc   a                        ;for good luck
1047 C43D 0A                    asl   a                        ;bytes from words do ever come
1048 C43E              ;
1049 C43E 85 78                 sta   lastSBIndex
1050 C440 1A                    inc   a
1051 C441 1A                    inc   a
1052 C442              ;
1053 C442 48                    pha   
1054 C443 D4 7E                 pei   mUserID
1055 C445 F4 00 80              pea   $8000
1056 C448 F4 00 00 F4           PushLong #0 
1057 C44E              ;
1058 C44E A2 02 09 22           _NewHandle 
1059 C455              ;
1060 C455 90 15                 bcc   NoMemErr2
1061 C457              ;mem err:
1062 C457 85 44                 sta   temp                     ;error code
1063 C459 FA                    plx   
1064 C45A FA                    plx   
1065 C45B              ;
1066 C45B              ;dispose of the already-allocated handle:
1067 C45B A5 3E 48 A5           PushLong <flbHandle 
1068 C461 A2 02 10 22           _DisposeHandle 
1069 C468              ;
1070 C468 A5 44                 lda   temp                     ;error code
1071 C46A 38                    sec                            ;signal an error
1072 C46B 6B                    rtl   
1073 C46C              ;
1074 C46C              NoMemErr2                               ;
1075 C46C              ;
1076 C46C 68                    pla   
1077 C46D 85 34                 sta   sbHandle
1078 C46F 68                    pla   
1079 C470 85 36                 sta   sbHandle+2
1080 C472              ;
1081 C472 A7 34                 lda   [sbHandle]               ;deref
1082 C474 85 38                 sta   scaledBytesPtr
1083 C476 A0 02 00              ldy   #2
1084 C479 B7 34                 lda   [sbHandle],y
1085 C47B 85 3A                 sta   scaledBytesPtr+2
1086 C47D              ;
1087 C47D              ;carry should still be clear, but just in case . . .
1088 C47D 18                    clc   
1089 C47E              ;
1090 C47E 6B                    rtl   
1091 C47F                       ENDP 
1092 C47F
1093 C47F
1094 C47F
1095 C47F                       title ' CalcNewFntSz' 
1096 C47F              ****************************************************************
1097 C47F              *
1098 C47F              CalcNewFntSz PROC 
1099 C47F              *
1100 C47F              *  This subroutine calculates the size of the new, scaled font and  
1101 C47F              *  allocates a handle of the appropriate size.  The handle is       
1102 C47F              *  newFontHandle.
1103 C47F              *
1104 C47F              *  CalcNewFntSz also calculates newAscent, newDescent, newChHeight, 
1105 C47F              *  and newRowBytes, which it needs for the new font size.
1106 C47F              *
1107 C47F              *  If there is a memory error, the routine returns with the carry   
1108 C47F              *  set, the error code in the acc., and no new handle allocated.    
1109 C47F              *  Also, the routine can generate a "size error" if the requested   
1110 C47F              *  font is bigger than our font data structure allows for; as       
1111 C47F              *  usual, acc. and carry will be set accordingly.  Otherwise the    
1112 C47F              *  routine returns with carry clear.
1113 C47F              *
1114 C47F              * 
1115 C47F              * NOTE:  strike width in pixels < 2 ** 16
1116 C47F              * (because it's in the last location table entry)
1117 C47F              * This also means:
1118 C47F              *        strike width in bytes < 2 ** 8
1119 C47F              *        strike width in words < 2 ** 7
1120 C47F              * ALSO:
1121 C47F              *        total strike size in words < 2 ** 16
1122 C47F              * (because the owTLoc, which is in words, must leapfrog
1123 C47F              * over the strike - and more)
1124 C47F              * 
1125 C47F              * ALSO:
1126 C47F              * we can for convenience assume
1127 C47F              *         total strike size in bytes < 2 ** 16
1128 C47F              * because every bit of code, in ROM or out, uses a simple asl to
1129 C47F              * double owTLoc, ignoring the high bit entirely.  Whether this is
1130 C47F              * a bug or a feature I'll leave for some other time.
1131 C47F
1132 C47F              * END OF NOTE
1133 C47F              * 
1134 C47F              *
1135 C47F              * Inputs:
1136 C47F              *                   direct page values.
1137 C47F              *
1138 C47F              * Outputs:
1139 C47F              *                   none
1140 C47F              *
1141 C47F              * External Refs:
1142 C47F              *                   none
1143 C47F              *
1144 C47F              * Entry Points:
1145 C47F              *                   none
1146 C47F              *
1147 C47F                       longa on                       ; mode
1148 C47F                       longi on
1149 C47F              *
1150 C47F              * Change History
1151 C47F              *
1152 C47F              * 11 Jan 87         Bennet Marks
1153 C47F              *
1154 C47F              * Coding started.
1155 C47F              *
1156 C47F              * 02 Feb 87         Bennet Marks
1157 C47F              *
1158 C47F              * First pass complete.
1159 C47F              *
1160 C47F              * 07 Oct 88         Sue Dumont
1161 C47F              *
1162 C47F              * Modified newStrikeSize to be a long which will now allow larger
1163 C47F              * fonts to be created.  This is possible since owTLoc now has a
1164 C47F              * high word present in the IIGS font header (highOwTLoc).
1165 C47F              *
1166 C47F              ****************************************************************
1167 C47F              ;
1168 C47F              ;start with the new vertical measures:
1169 C47F              ;
1170 C47F A0 12 00              ldy   #FAscent
1171 C482 B7 0C                 lda   [fontRecPtr],y           	;old ascent
1172 C484 22 6C C7 FC           jsl   ScaleByte
1173 C488 85 56                 sta   newAscent
1174 C48A              ;
1175 C48A A0 14 00              ldy   #FDescent
1176 C48D B7 0C                 lda   [fontRecPtr],y
1177 C48F 22 6C C7 FC           jsl   ScaleByte
1178 C493 85 58                 sta   newDescent
1179 C495              ;
1180 C495 18                    clc   
1181 C496 65 56                 adc   newAscent
1182 C498 85 5A                 sta   newChHeight
1183 C49A              ;
1184 C49A A0 0E 00              ldy   #FBBDY
1185 C49D B7 0C                 lda   [fontRecPtr],y
1186 C49F 85 4C                 sta   chHeight                 	;needed for sizing and later
1187 C4A1              ;
1188 C4A1              ;now do the new strike size -
1189 C4A1              ;get old strike width in pixels:
1190 C4A1              ;
1191 C4A1 A4 4E                 ldy   tableLength
1192 C4A3 88                    dey   
1193 C4A4 88                    dey   
1194 C4A5 B7 18                 lda   [locTPtr],y
1195 C4A7              ;(last loc table entry = strike width in pixels)
1196 C4A7              ;
1197 C4A7              ;
1198 C4A7 48                    pha                            ;for result
1199 C4A8 48                    pha   
1200 C4A9              ;scale it:
1201 C4A9 48                    pha                            ;push strike width in pixels
1202 C4AA D4 7A                 pei   mWantSize
1203 C4AC              ;
1204 C4AC A2 0B 09 22           _Multiply                      ;strike width in pixels * mWantSize
1205 C4B3              ;
1206 C4B3 68                    pla   
1207 C4B4 85 44                 sta   temp                     	;result of multiplication
1208 C4B6 68                    pla   
1209 C4B7 85 46                 sta   temp+2
1210 C4B9              ;
1211 C4B9 A5 7C                 lda   mBestSize
1212 C4BB 3A                    dec   a
1213 C4BC 18                    clc   
1214 C4BD 65 44                 adc   temp                     	;to round up
1215 C4BF 85 44                 sta   temp
1216 C4C1 90 02                 bcc   NoCarry1
1217 C4C3 E6 46                 inc   temp+2
1218 C4C5              NoCarry1  
1219 C4C5 48                    pha                            ;space for result
1220 C4C6 48                    pha   
1221 C4C7 48                    pha   
1222 C4C8 48                    pha   
1223 C4C9 A5 46 48 A5           PushLong <temp 
1224 C4CF F4 00 00              pea   0
1225 C4D2 D4 7C                 pei   mBestSize
1226 C4D4              ;
1227 C4D4 A2 0B 0D 22           _LongDivide                    ;mWantSize / mBestSize
1228 C4DB              ;
1229 C4DB 68                    pla                            ;scaling factor result, low word
1230 C4DC 85 44                 sta   temp
1231 C4DE FA                    plx                            ;high word, must be 0 (see note)
1232 C4DF F0 05                 beq   NoSizeErr1
1233 C4E1              ;size error:
1234 C4E1 FA                    plx   
1235 C4E2 FA                    plx                            ;get rid of quotient
1236 C4E3 82 64 00              brl   SizeError
1237 C4E6              ;
1238 C4E6 FA           NoSizeErr1 plx   
1239 C4E7 FA                    plx                            ;quotient, unneeded
1240 C4E8              ;
1241 C4E8              ;now, we may have rounded off as much as 1 pixel from each individual
1242 C4E8              ;character image by doing the whole thing at once, so to compensate:
1243 C4E8              ;
1244 C4E8 A5 4E                 lda   tableLength
1245 C4EA 4A                    lsr   a
1246 C4EB 18                    clc   
1247 C4EC 65 44                 adc   temp
1248 C4EE 90 03                 bcc   NoSizeErr2
1249 C4F0 82 57 00              brl   SizeError
1250 C4F3              NoSizeErr2  
1251 C4F3              ;
1252 C4F3              ;that's  (an upper bound on) the width in pixels -
1253 C4F3              ;now let's boil it down to words (and even bytes)
1254 C4F3              ;
1255 C4F3 18                    clc   
1256 C4F4 69 0F 00              adc   #15                      	;to round up
1257 C4F7 4A                    lsr   a
1258 C4F8 4A                    lsr   a
1259 C4F9 4A                    lsr   a
1260 C4FA 29 FE FF              and   #first15Bits
1261 C4FD              ;that's even bytes:
1262 C4FD 85 5E                 sta   newRowBytes
1263 C4FF              ;
1264 C4FF              ;multiply by height:
1265 C4FF F4 00 00 F4           PushLong #0 
1266 C505 D4 5E                 pei   newRowBytes
1267 C507 D4 5A                 pei   newChHeight
1268 C509              ;
1269 C509 A2 0B 09 22           _Multiply 
1270 C510              ;
1271 C510 68                    pla                            ;result low
1272 C511 85 60                 sta   newStrikeSize
1273 C513 68                    pla                            ;may have high word for strike size 
1274 C514 85 62                 sta   newStrikeSize+2          	; in Version 1.02
1275 C516                                                      ;
1276 C516 A9 28 00              lda   #(newHeadLength+macHeadLength) ;version 1.02 header
1277 C519 18                    clc   
1278 C51A 65 4E                 adc   tableLength
1279 C51C 65 4E                 adc   tableLength              	;two tables
1280 C51E 65 60                 adc   newStrikeSize
1281 C520 85 44                 sta   temp                     	;new strike size, in bytes
1282 C522 A5 62                 lda   newStrikeSize+2          	;may exceed 64K (SMD 4 Oct 88)
1283 C524 90 01                 bcc   StoreSize
1284 C526 1A                    inc   a
1285 C527
1286 C527 85 46        StoreSize sta   temp+2
1287 C529 F4 00 00 F4           PushLong #0                    ;resulting handle
1288 C52F D4 46                 pei   temp+2                   	;high word of size in bytes
1289 C531 D4 44                 pei   temp                     	;low word
1290 C533 D4 7E                 pei   mUserId
1291 C535 F4 00 80              pea   $8000
1292 C538 F4 00 00 F4           PushLong #0 
1293 C53E              ;
1294 C53E A2 02 09 22           _NewHandle                     ;allocate memory for new
1295 C545              ;                                       ; font record
1296 C545 90 08                 bcc   NoMemErr
1297 C547              ;mem error:
1298 C547 FA                    plx   
1299 C548 FA                    plx   
1300 C549 6B                    rtl   
1301 C54A              ;
1302 C54A              ;code for size error:
1303 C54A              SizeError  
1304 C54A A9 0C 1B              lda   #scaleSizeErr            	;what the Font Manager calls it
1305 C54D 38                    sec                            ;to signal error
1306 C54E 6B                    rtl   
1307 C54F              ;
1308 C54F              NoMemErr  
1309 C54F 68                    pla   
1310 C550 85 1C                 sta   nFontHandle
1311 C552 68                    pla   
1312 C553 85 1E                 sta   nFontHandle+2
1313 C555              ;
1314 C555 18                    clc                            ;No Error
1315 C556 6B                    rtl   
1316 C557                       ENDP 
1317 C557
1318 C557
1319 C557
1320 C557                       title ' CalcNewFntPtrs' 
1321 C557              ****************************************************************
1322 C557              *
1323 C557              CalcNewFntPtrs PROC 
1324 C557              *
1325 C557              *  This subroutine sets all the pointers for the various pieces of
1326 C557              *  the new font.
1327 C557              *
1328 C557              *
1329 C557              * Inputs:
1330 C557              *                   none
1331 C557              *
1332 C557              * Outputs:
1333 C557              *                   carry bit set if size error 
1334 C557              *
1335 C557              * External Refs:
1336 C557              *                   none
1337 C557              *
1338 C557              * Entry Points:
1339 C557              *                   none
1340 C557              *
1341 C557                       longa on                       ; mode
1342 C557                       longi on
1343 C557              *
1344 C557              * Change History
1345 C557              *
1346 C557              * 13 Jan 87         Bennet Marks
1347 C557              *
1348 C557              * Coding started.
1349 C557              *
1350 C557              * 03 Feb 87         Bennet Marks
1351 C557              *
1352 C557              * First pass complete.
1353 C557              *
1354 C557              * 07 Oct 88         Sue Dumont
1355 C557              *
1356 C557              * Added high word of strike size.  Also, this routine returns
1357 C557              * with the carry bit set if a size error occurs.
1358 C557              *
1359 C557              ****************************************************************
1360 C557
1361 C557              ;
1362 C557 A7 1C                 lda   [nFontHandle]            ;dereference handle
1363 C559 85 20                 sta   nFontHeadPtr
1364 C55B A0 02 00              ldy   #2
1365 C55E B7 1C                 lda   [nFontHandle],y
1366 C560 85 22                 sta   nFontHeadPtr+2
1367 C562              ;
1368 C562 A5 20                 lda   nFontHeadPtr
1369 C564 18                    clc   
1370 C565 69 0E 00              adc   #newHeadLength           ;(10 Oct 88) compensate for additional IIGS header field
1371 C568 85 24                 sta   nFontRecPtr
1372 C56A A5 22                 lda   nFontHeadPtr+2
1373 C56C 90 02                 bcc   NoCarry1
1374 C56E 1A                    inc   a
1375 C56F 18                    clc                            ;keep carry cleared
1376 C570              NoCarry1                                ;
1377 C570 85 26                 sta   nFontRecPtr+2
1378 C572              ;
1379 C572 A5 24                 lda   nFontRecPtr
1380 C574 69 1A 00              adc   #macHeadLength
1381 C577 85 28                 sta   nStrikePtr
1382 C579 A5 26                 lda   nFontRecPtr+2
1383 C57B 90 01                 bcc   NoCarry2
1384 C57D 1A                    inc   a
1385 C57E
1386 C57E 85 2A        NoCarry2 sta   nStrikePtr+2
1387 C580              ;
1388 C580 A5 28                 lda   nStrikePtr
1389 C582 18                    clc   
1390 C583 65 60                 adc   newStrikeSize
1391 C585 85 30                 sta   nLocTPtr
1392 C587 A5 2A                 lda   nStrikePtr+2
1393 C589 65 62                 adc   newStrikeSize+2          ;add high word of strike size - Version 1.02
1394 C58B 90 04                 bcc   NoCarry3                 ;carry already added (4 Oct 88)
1395 C58D              ** Size Error **
1396 C58D A9 0C 1B              lda   #scaleSizeErr            ;set error for Font Manager
1397 C590 6B                    rtl                            ;carry is already set
1398 C591
1399 C591              NoCarry3                                ;
1400 C591 85 32                 sta   nLocTPtr+2
1401 C593 A5 30                 lda   nLocTPtr
1402 C595 18                    clc   
1403 C596 65 4E                 adc   tableLength
1404 C598 85 2C                 sta   nOWTPtr
1405 C59A A5 32                 lda   nLocTPtr+2
1406 C59C 90 02                 bcc   NoCarry4
1407 C59E 1A                    inc   a
1408 C59F 18                    clc   
1409 C5A0              NoCarry4  
1410 C5A0 85 2E                 sta   nOWTPtr+2
1411 C5A2
1412 C5A2 6B                    rtl   
1413 C5A3                       ENDP 
1414 C5A3
1415 C5A3
1416 C5A3
1417 C5A3
1418 C5A3
1419 C5A3
1420 C5A3                       title ' SetNewHdrVals' 
1421 C5A3              ****************************************************************
1422 C5A3              *
1423 C5A3              SetNewHdrVals PROC 
1424 C5A3              *
1425 C5A3              *  This subroutine finds and/or calculates the values to go in the  
1426 C5A3              *  new font's header fields (both Gumby header and Mac header), and 
1427 C5A3              *  places them in the new headers.
1428 C5A3              *
1429 C5A3              *  This routine can generate a "size error", if the requested font  
1430 C5A3              *  is too large to permit a 1-word owTLoc value.  In this case,     
1431 C5A3              *  the error code will be in the acc., and the carry will be set.   
1432 C5A3              *  Otherwise, the routine returns with the carry clear.
1433 C5A3              *
1434 C5A3              *
1435 C5A3              * Inputs:
1436 C5A3              *                   none
1437 C5A3              *
1438 C5A3              * Outputs:
1439 C5A3              *                   none
1440 C5A3              *
1441 C5A3              * External Refs:
1442 C5A3              *                   none
1443 C5A3              *
1444 C5A3              * Entry Points:
1445 C5A3              *                   none
1446 C5A3              *
1447 C5A3                       longa on                       ; mode
1448 C5A3                       longi on
1449 C5A3              *
1450 C5A3              * Change History
1451 C5A3              *
1452 C5A3              * 13 Jan 87         Bennet Marks
1453 C5A3              *
1454 C5A3              * Coding started.
1455 C5A3              *
1456 C5A3              * 03 Feb 87         Bennet Marks
1457 C5A3              *
1458 C5A3              * First pass complete.
1459 C5A3              *
1460 C5A3              * 10 Oct 88         Sue Dumont
1461 C5A3              *
1462 C5A3              * Sets font record values for Version 1.02
1463 C5A3              *
1464 C5A3              ****************************************************************
1465 C5A3              ;
1466 C5A3 A9 07 00              lda   #(newHeadLength/2)       ;10 Oct 88 - SMD
1467 C5A6 87 20                 sta   [nFontHeadPtr]           	;offset-to-Mac field
1468 C5A8              ;
1469 C5A8 A0 00 00              ldy   #o_FLFamNum
1470 C5AB B7 40                 lda   [fontLorePtr],y
1471 C5AD A0 02 00              ldy   #o_FamNum
1472 C5B0 97 20                 sta   [nFontHeadPtr],y
1473 C5B2              ;
1474 C5B2 A0 02 00              ldy   #o_FLStyle
1475 C5B5 B7 40                 lda   [fontLorePtr],y
1476 C5B7 A0 04 00              ldy   #o_Style
1477 C5BA 97 20                 sta   [nFontHeadPtr],y
1478 C5BC              ;
1479 C5BC A5 7A                 lda   mWantSize
1480 C5BE A0 06 00              ldy   #o_Size
1481 C5C1 97 20                 sta   [nFontHeadPtr],y
1482 C5C3              ****
1483 C5C3              **** (10 Oct 88)  This version of the Font Scaler is 1.02.
1484 C5C3              ****              Version 1.02 has the additional word, highOwTLoc,
1485 C5C3              ****              in the Apple IIGS font header
1486 C5C3              ****
1487 C5C3 A9 05 01              lda   #newVersion              	;Version 1.02
1488 C5C6 A0 08 00              ldy   #o_Version
1489 C5C9 97 20                 sta   [nFontHeadPtr],y
1490 C5CB              ;
1491 C5CB A0 0A 00              ldy   #o_FBRExtent
1492 C5CE B7 40                 lda   [fontLorePtr],y
1493 C5D0 22 6C C7 FC           jsl   ScaleByte
1494 C5D4 A0 0A 00              ldy   #o_FBRExtent
1495 C5D7 97 20                 sta   [nFontHeadPtr],y
1496 C5D9              ;
1497 C5D9              ;so much for the Gumby header - let's get to the Mac header
1498 C5D9              ;
1499 C5D9 A0 00 00              ldy   #FFormat
1500 C5DC B7 0C                 lda   [fontRecPtr],y
1501 C5DE 97 24                 sta   [nFontRecPtr],y
1502 C5E0              ;
1503 C5E0 A0 02 00              ldy   #FMinChar
1504 C5E3 B7 0C                 lda   [fontRecPtr],y
1505 C5E5 97 24                 sta   [nFontRecPtr],y
1506 C5E7              ;
1507 C5E7 A0 04 00              ldy   #FMaxChar
1508 C5EA B7 0C                 lda   [fontRecPtr],y
1509 C5EC 97 24                 sta   [nFontRecPtr],y
1510 C5EE              ;
1511 C5EE A0 06 00              ldy   #FMaxWd
1512 C5F1 B7 0C                 lda   [fontRecPtr],y
1513 C5F3 22 6C C7 FC           jsl   ScaleByte
1514 C5F7 A0 06 00              ldy   #FMaxWd
1515 C5FA 97 24                 sta   [nFontRecPtr],y
1516 C5FC              ;
1517 C5FC A0 08 00              ldy   #FBBOX
1518 C5FF B7 0C                 lda   [fontRecPtr],y
1519 C601              ;assume a non-positive kern for now
1520 C601 49 FF FF              eor   #allBitsOn
1521 C604 1A                    inc   a                        	;invert kern
1522 C605 22 6C C7 FC           jsl   ScaleByte
1523 C609 49 FF FF              eor   #allBitsOn               	;invert result
1524 C60C 1A                    inc   a
1525 C60D A0 08 00              ldy   #FBBOX
1526 C610 97 24                 sta   [nFontRecPtr],y
1527 C612              ;
1528 C612 A0 0C 00              ldy   #FBBDX
1529 C615 B7 0C                 lda   [fontRecPtr],y
1530 C617 22 6C C7 FC           jsl   ScaleByte
1531 C61B A0 0C 00              ldy   #FBBDX
1532 C61E 97 24                 sta   [nFontRecPtr],y
1533 C620              ;
1534 C620 A5 5A                 lda   newChHeight
1535 C622 A0 0E 00              ldy   #FBBDY
1536 C625 97 24                 sta   [nFontRecPtr],y
1537 C627              ;
1538 C627              ;calculate new owTLoc:
1539 C627              ;
1540 C627 A5 24                 lda   nFontRecPtr
1541 C629 18                    clc   
1542 C62A 69 10 00              adc   #FLength
1543 C62D 85 44                 sta   temp
1544 C62F A5 26                 lda   nFontRecPtr+2
1545 C631 90 01                 bcc   NoCarry
1546 C633 1A                    inc   a
1547 C634              NoCarry                                 ;
1548 C634 85 46                 sta   temp+2
1549 C636              ;
1550 C636 A5 2C                 lda   nOWTPtr
1551 C638 38                    sec   
1552 C639 E5 44                 sbc   temp
1553 C63B 85 44                 sta   temp
1554 C63D A5 2E                 lda   nOWTPtr+2
1555 C63F E5 46                 sbc   temp+2                   	;owTLoc has high word
1556 C641 85 46                 sta   temp+2                   	;in Version 1.02
1557 C643
1558 C643 4A                    lsr   a                        	;high word of offset in words
1559 C644 A0 0C 00              ldy   #o_highOwTLoc            	;to offset/width table
1560 C647 97 20                 sta   [nFontHeadPtr],y         ;store in IIGS font header
1561 C649
1562 C649 A5 44                 lda   temp
1563 C64B 6A                    ror   a                        	;rotate the bit in from the
1564 C64C A0 10 00              ldy   #FLength                 	;high word
1565 C64F 97 24                 sta   [nFontRecPtr],y
1566 C651
1567 C651 A5 56                 lda   newAscent
1568 C653 A0 12 00              ldy   #FAscent
1569 C656 97 24                 sta   [nFontRecPtr],y
1570 C658              ;
1571 C658 A5 58                 lda   newDescent
1572 C65A A0 14 00              ldy   #FDescent
1573 C65D 97 24                 sta   [nFontRecPtr],y
1574 C65F              ;
1575 C65F 49 FF FF              eor   #allBitsOn               ;invert it
1576 C662 1A                    inc   a
1577 C663 A0 0A 00              ldy   #FBBOY                   ;for nDescent
1578 C666 97 24                 sta   [nFontRecPtr],y
1579 C668              ;
1580 C668 A0 16 00              ldy   #FLeading
1581 C66B B7 0C                 lda   [fontRecPtr],y
1582 C66D 22 6C C7 FC           jsl   ScaleByte
1583 C671 A0 16 00              ldy   #FLeading
1584 C674 97 24                 sta   [nFontRecPtr],y
1585 C676              ;
1586 C676 A5 5E                 lda   newRowBytes
1587 C678 4A                    lsr   a
1588 C679 A0 18 00              ldy   #FRaster
1589 C67C 97 24                 sta   [nFontRecPtr],y
1590 C67E              ;
1591 C67E 18                    clc                            ;no errors
1592 C67F 6B                    rtl   
1593 C680                       ENDP 
1594 C680
1595 C680
1596 C680
1597 C680
1598 C680
1599 C680
1600 C680
1601 C680                       title ' ClearNewStrike' 
1602 C680              ****************************************************************
1603 C680              *
1604 C680              ClearNewStrike PROC 
1605 C680              *
1606 C680              *  This subroutine zeroes out the new font strike (the scaled
1607 C680              *  character images are going to be OR'ed into it).
1608 C680              *
1609 C680              *
1610 C680              * Inputs:
1611 C680              *                   none
1612 C680              *
1613 C680              * Outputs:
1614 C680              *                   none
1615 C680              *
1616 C680              * External Refs:
1617 C680              *                   none
1618 C680              *
1619 C680              * Entry Points:
1620 C680              *                   none
1621 C680              *
1622 C680                       longa on                       ; mode
1623 C680                       longi on
1624 C680              *
1625 C680              * Change History
1626 C680              *
1627 C680              * 13 Jan 87         Bennet Marks
1628 C680              *
1629 C680              * Coding started.
1630 C680              *
1631 C680              * 13 Jan 87         Bennet Marks
1632 C680              *
1633 C680              * First pass complete.
1634 C680              *
1635 C680              * 11 Oct 88         Sue Dumont
1636 C680              *
1637 C680              * Rewrote entire routine to zero out the font strike.  This was
1638 C680              * done to allow a strike size to be greater than 64K.
1639 C680              *
1640 C680              ****************************************************************
1641 C680
1642 C680 A5 28                 lda   nStrikePtr               	;use temp ptr for nStrikePtr
1643 C682 85 44                 sta   temp
1644 C684 A5 2A                 lda   nStrikePtr+2
1645 C686 85 46                 sta   temp+2
1646 C688
1647 C688 A9 00 00              lda   #0
1648 C68B A6 62                 ldx   newStrikeSize+2          	;high word of strike size
1649 C68D F0 10                 beq   LessThan64K
1650 C68F A0 FE FF     BankLoop ldy   #$FFFE
1651 C692 97 44        NextWord1 sta   [temp],y
1652 C694 88                    dey   
1653 C695 88                    dey   
1654 C696 D0 FA                 bne   NextWord1
1655 C698 87 44                 sta   [temp]                   	;zero out last word
1656 C69A E6 46                 inc   temp+2
1657 C69C CA                    dex   
1658 C69D D0 F0                 bne   BankLoop
1659 C69F A4 60        LessThan64K ldy   newStrikeSize
1660 C6A1 80 02                 bra   EnterLoop
1661 C6A3 97 44        NextWord2 sta   [temp],y
1662 C6A5 88           EnterLoop dey   
1663 C6A6 88                    dey   
1664 C6A7 D0 FA                 bne   NextWord2
1665 C6A9 87 44                 sta   [temp]                   	;zero out last word
1666 C6AB
1667 C6AB 6B                    rtl   
1668 C6AC                       ENDP 
1669 C6AC
1670 C6AC
1671 C6AC
1672 C6AC
1673 C6AC                       title ' TablesNStrike' 
1674 C6AC              ****************************************************************
1675 C6AC              *
1676 C6AC              TablesNStrike PROC 
1677 C6AC              *
1678 C6AC              *  This subroutine fills in the values for the new offset/width
1679 C6AC              *  table and location table, and places the scaled character
1680 C6AC              *  images in the new font strike.
1681 C6AC              *
1682 C6AC              *
1683 C6AC              * Inputs:
1684 C6AC              *                   none
1685 C6AC              *
1686 C6AC              * Outputs:
1687 C6AC              *                   none
1688 C6AC              *
1689 C6AC              * External Refs:
1690 C6AC              *                   none
1691 C6AC              *
1692 C6AC              * Entry Points:
1693 C6AC              *                   none
1694 C6AC              *
1695 C6AC                       longa on                       ; mode
1696 C6AC                       longi on
1697 C6AC              *
1698 C6AC              * Change History
1699 C6AC              *
1700 C6AC              * 13 Jan 87         Bennet Marks
1701 C6AC              *
1702 C6AC              * Coding started.
1703 C6AC              *
1704 C6AC              * 15 Jan 87         Bennet Marks
1705 C6AC              *
1706 C6AC              * First pass complete.
1707 C6AC              *
1708 C6AC              ****************************************************************
1709 C6AC
1710 C6AC              ;
1711 C6AC A5 4E                 lda   tableLength
1712 C6AE 3A                    dec   a
1713 C6AF 3A                    dec   a
1714 C6B0 85 66                 sta   lastIndex
1715 C6B2              ;
1716 C6B2 A9 00 00              lda   #0
1717 C6B5 85 64                 sta   currIndex
1718 C6B7 85 68                 sta   currPixel                ;in new strike
1719 C6B9 87 30                 sta   [nLocTPtr]
1720 C6BB              ;
1721 C6BB              NextChar                                ;
1722 C6BB A4 64                 ldy   currIndex
1723 C6BD B7 14                 lda   [owTPtr],y               ;offset/width value
1724 C6BF C9 FF FF              cmp   #owMSVal
1725 C6C2 D0 10                 bne   DefinedChar
1726 C6C4              ;
1727 C6C4              ;character is not defined:
1728 C6C4 97 2C                 sta   [nOWTPtr],y
1729 C6C6 A5 68                 lda   currPixel
1730 C6C8 C8                    iny   
1731 C6C9 C8                    iny   
1732 C6CA 97 30                 sta   [nLocTPtr],y
1733 C6CC              ;
1734 C6CC C4 66                 cpy   lastIndex
1735 C6CE F0 4E                 beq   NoMoreChars
1736 C6D0              ;(actually, this really can't happen here - the missing symbol must
1737 C6D0              ;be defined)
1738 C6D0 84 64                 sty   currIndex
1739 C6D2 80 E7                 bra   NextChar
1740 C6D4              ;
1741 C6D4 85 44        DefinedChar sta   temp                  ;create new offset/width value
1742 C6D6 29 FF 00              and   #lowByte
1743 C6D9 22 6C C7 FC           jsl   ScaleByte
1744 C6DD 85 46                 sta   temp+2
1745 C6DF              ;
1746 C6DF A5 44                 lda   temp
1747 C6E1 EB                    xba   
1748 C6E2 29 FF 00              and   #lowByte
1749 C6E5 22 6C C7 FC           jsl   ScaleByte
1750 C6E9 EB                    xba   
1751 C6EA 05 46                 ora   temp+2
1752 C6EC              ;
1753 C6EC A4 64                 ldy   currIndex
1754 C6EE              ;
1755 C6EE 97 2C                 sta   [nOWTPtr],y              ;store new offset/width value
1756 C6F0              ;
1757 C6F0 B7 18                 lda   [locTPtr],y
1758 C6F2 85 44                 sta   temp
1759 C6F4 C8                    iny   
1760 C6F5 C8                    iny   
1761 C6F6 84 64                 sty   currIndex
1762 C6F8 B7 18                 lda   [locTPtr],y
1763 C6FA 38                    sec   
1764 C6FB E5 44                 sbc   temp                     ;image width
1765 C6FD F0 13                 beq   ImWidth0
1766 C6FF              ;
1767 C6FF              ;image width NOT 0:
1768 C6FF 85 6A                 sta   ImWidth
1769 C701 22 6C C7 FC           jsl   ScaleByte
1770 C705 85 6C                 sta   newImWidth
1771 C707              ;
1772 C707              ;{TIME FOR PIXELMAP SCALING CODE
1773 C707              ;
1774 C707              ;  at this point the image of the character from the source font
1775 C707              ;  can be scaled and fed into the new font.
1776 C707              ;
1777 C707              ;  The source rectangle starts in column TEMP and ends in
1778 C707              ;  column TEMP + IMWIDTH - 1 (this is purely pixel notation,
1779 C707              ;  not QDII rectangle description).  The dest rectangle goes
1780 C707              ;  from CURRPIXEL to CURRPIXEL + NEWIMWIDTH - 1.
1781 C707              ;
1782 C707              ;  Some of the updates in the code below may, in fact, be done
1783 C707              ;  in and around the map-scaling code.
1784 C707              ;
1785 C707              ;
1786 C707              ;
1787 C707 22 FC C7 FC           jsl   ScaleBits
1788 C70B              ;
1789 C70B              ;
1790 C70B              ;
1791 C70B              ;END OF PIXELMAP SCALING CODE}
1792 C70B              ;
1793 C70B              ;
1794 C70B A5 68                 lda   currPixel
1795 C70D 18                    clc   
1796 C70E 65 6C                 adc   newImWidth
1797 C710 85 68                 sta   currPixel
1798 C712              ;and fall into . . .
1799 C712              ;
1800 C712              ImWidth0                                ;
1801 C712 A5 68                 lda   currPixel
1802 C714 A4 64                 ldy   currIndex
1803 C716 97 30                 sta   [nLocTPtr],y
1804 C718              ;
1805 C718 C4 66                 cpy   lastIndex
1806 C71A F0 02                 beq   NoMoreChars
1807 C71C 80 9D                 bra   NextChar
1808 C71E              ;
1809 C71E              NoMoreChars                             ;
1810 C71E              ;
1811 C71E              ;y has the most recent index
1812 C71E A9 FF FF              lda   #(-1)
1813 C721 97 2C                 sta   [nOWTPtr],y
1814 C723              ;
1815 C723 6B                    rtl   
1816 C724                       ENDP 
1817 C724
1818 C724                       title ' InitByteScaler and ScaleByte' 
1819 C724              ****************************************************************
1820 C724              *
1821 C724              InitByteScaler PROC 
1822 C724              *
1823 C724              *  This subroutine creates a table of integer multiples of the      
1824 C724              *  scale factor mWantSize/mBestSize, for small integers.  The       
1825 C724              *  multiples are rounded up.
1826 C724              *
1827 C724              *  It is my assumption that the scaling that has to be done on      
1828 C724              *  every character offset, character width, and image width (as     
1829 C724              *  well as other values, such as the ascent and descent) will       
1830 C724              *  involve so many repeat values, and/or values near each other,    
1831 C724              *  that creating and using this list is time-efficient.
1832 C724              *
1833 C724              *  The integers scaled here are 0,1,...,maxB, where maxB =
1834 C724              *  max{ascent,descent,leading,fbrExtent,fRectMax}.  Each value      
1835 C724              *  gets its own word in the list.  lastSBIndex, the index of the    
1836 C724              *  last entry we want in the list, is calculated in SetUp2Bufs.     
1837 C724              *
1838 C724              *  (There's no good reason why this routine shouldn't be incorpor-  
1839 C724              *  ated into SetUp2Bufs as well.)
1840 C724              *
1841 C724              *  The zero entry in the list is pointed to by ScaledBytesPtr.      
1842 C724              *
1843 C724              *
1844 C724              * Inputs:
1845 C724              *                   none
1846 C724              *
1847 C724              * Outputs:
1848 C724              *                   none
1849 C724              *
1850 C724              * External Refs:
1851 C724              *                   none
1852 C724              *
1853 C724              * Entry Points:
1854 C724              *                   none
1855 C724              *
1856 C724                       longa on                       ; mode
1857 C724                       longi on
1858 C724              *
1859 C724              * Change History
1860 C724              *
1861 C724              * 13 Jan 87         Bennet Marks
1862 C724              *
1863 C724              * Coding started.
1864 C724              *
1865 C724              * 16 Jan 87         Bennet Marks
1866 C724              *
1867 C724              * First pass complete.
1868 C724              *
1869 C724              ****************************************************************
1870 C724
1871 C724              ;
1872 C724 F4 00 00              PushWord #0 
1873 C727 F4 00 00              PushWord #0 
1874 C72A D4 7A                 pei   mWantSize
1875 C72C D4 7C                 pei   mBestSize
1876 C72E              ;
1877 C72E A2 0B 0B 22           _UDivide 
1878 C735              ;
1879 C735 68                    pla   
1880 C736 85 6E                 sta   quotient
1881 C738 68                    pla   
1882 C739 85 70                 sta   remainder
1883 C73B              ;
1884 C73B A5 7C                 lda   mBestSize
1885 C73D 3A                    dec   a
1886 C73E 85 72                 sta   bucket                   ;for rounding up
1887 C740              ;
1888 C740 A9 00 00              lda   #0
1889 C743 87 38                 sta   [ScaledBytesPtr]         ;multiply by 0
1890 C745 85 74                 sta   lastQuo
1891 C747 A0 02 00              ldy   #2
1892 C74A              ;
1893 C74A              NextByte                                ;
1894 C74A A5 72                 lda   bucket
1895 C74C 18                    clc   
1896 C74D 65 70                 adc   remainder
1897 C74F C5 7C                 cmp   mBestSize
1898 C751 30 05                 bmi   NoCarry
1899 C753              ;carry:
1900 C753 E6 74                 inc   lastQuo
1901 C755 38                    sec   
1902 C756 E5 7C                 sbc   mBestSize
1903 C758              ;
1904 C758              NoCarry                                 ;
1905 C758 85 72                 sta   bucket
1906 C75A              ;
1907 C75A A5 74                 lda   lastQuo
1908 C75C 18                    clc   
1909 C75D 65 6E                 adc   quotient
1910 C75F 85 74                 sta   lastQuo
1911 C761 97 38                 sta   [ScaledBytesPtr],y
1912 C763              ;
1913 C763 C4 78                 cpy   lastSBIndex
1914 C765 F0 04                 beq   NoMoreBytes
1915 C767              ;
1916 C767 C8                    iny   
1917 C768 C8                    iny   
1918 C769 80 DF                 bra   NextByte
1919 C76B              ;
1920 C76B              NoMoreBytes                             ;
1921 C76B 6B                    rtl   
1922 C76C                       ENDP 
1923 C76C
1924 C76C
1925 C76C
1926 C76C
1927 C76C              ****************************************************************
1928 C76C              *
1929 C76C              ScaleByte PROC 
1930 C76C              *
1931 C76C              *  This routine is used to scale small integer values by the scale  
1932 C76C              *  factor mWantSize/mBestSize.  ScaleByte accesses the list of      
1933 C76C              *  multiples set up by InitByteScaler.
1934 C76C              *
1935 C76C              *  ScaleByte is "a mite twitchy", and is really only designed to be 
1936 C76C              *  used in this particular context.  Values to be scaled must be    
1937 C76C              *  non-negative, and <= maxB.  See InitByteScaler and SetUp2Bufs    
1938 C76C              *  for more information.
1939 C76C              *
1940 C76C              *
1941 C76C              * Inputs:
1942 C76C              *                   none
1943 C76C              *
1944 C76C              * Outputs:
1945 C76C              *                   none
1946 C76C              *
1947 C76C              * External Refs:
1948 C76C              *                   none
1949 C76C              *
1950 C76C              * Entry Points:
1951 C76C              *                   none
1952 C76C              *
1953 C76C                       longa on                       ; mode
1954 C76C                       longi on
1955 C76C              *
1956 C76C              * Change History
1957 C76C              *
1958 C76C              * 13 Jan 87         Bennet Marks
1959 C76C              *
1960 C76C              * Coding started.
1961 C76C              *
1962 C76C              * 13 Jan 87         Bennet Marks
1963 C76C              *
1964 C76C              * First pass complete.
1965 C76C              *
1966 C76C              ****************************************************************
1967 C76C
1968 C76C              ;
1969 C76C 0A                    asl   a
1970 C76D A8                    tay   
1971 C76E B7 38                 lda   [ScaledBytesPtr],y
1972 C770              ;
1973 C770              ;There, there, that wasn't such a big deal after all, was it?
1974 C770              ;
1975 C770 6B                    rtl   
1976 C771                       ENDP 
1977 C771
1978 C771
1979 C771
1980 C771
1981 C771
1982 C771                       title ' FntMgr2FntSclr' 
1983 C771              ****************************************************************
1984 C771              *
1985 C771              FntMgr2FntSclr PROC 
1986 C771              *
1987 C771              *  This routine moves us from the Font Manager's 0-page to          
1988 C771              *  the Font Scaler's (which is QD II's 3rd 0-page).  It saves the   
1989 C771              *  bestSize, wantSize, and ProgID that the FM has kindly placed in  
1990 C771              *  x, y, and the acc. for us.  It also picks up portRef from        
1991 C771              *  QD II for us.
1992 C771              *
1993 C771              *
1994 C771              * Inputs:
1995 C771              *                   none
1996 C771              *
1997 C771              * Outputs:
1998 C771              *                   none
1999 C771              *
2000 C771              * External Refs:
2001 C771              *                   none
2002 C771              *
2003 C771              * Entry Points:
2004 C771              *                   none
2005 C771              *
2006 C771                       longa on                       ; mode
2007 C771                       longi on
2008 C771              *
2009 C771              * Change History
2010 C771              *
2011 C771              * 13 Jan 87         Bennet Marks
2012 C771              *
2013 C771              * Coding started.
2014 C771              *
2015 C771              * 10 Feb 87         Bennet Marks
2016 C771              *
2017 C771              * First pass complete.
2018 C771              *
2019 C771              ****************************************************************
2020 C771
2021 C771              ;
2022 C771              ;put needed values from Font Manager on stack:
2023 C771 DA                    phx                            ;bestSize
2024 C772 5A                    phy                            ;wantSize
2025 C773 48                    pha                            ;progID
2026 C774              ;
2027 C774              ;get QD II's (first) 0-page:
2028 C774 48                    pha   
2029 C775 48                    pha                            ;for result
2030 C776 F4 00 00              PushWord #0                    ;system
2031 C779 F4 04 00              PushWord #4                    ;QD II Tool Set Number
2032 C77C              ;
2033 C77C A2 01 0C 22           _GetWAP 
2034 C783 68                    pla                            ;QD II's (first) 0-page
2035 C784 FA                    plx                            ;junk
2036 C785              ;
2037 C785 5B                    tcd                            ;now in QuickDrawTwoLand
2038 C786              ;
2039 C786 A5 24                 lda   portRef
2040 C788 48                    pha   
2041 C789 A5 26                 lda   portRef+2
2042 C78B 48                    pha   
2043 C78C              ;
2044 C78C 7B                    tdc   
2045 C78D 18                    clc   
2046 C78E 69 00 02              adc   #$200                    ;our (QD II's third) 0-page
2047 C791 5B                    tcd   
2048 C792              ;
2049 C792              ;get back the values:
2050 C792 68                    pla   
2051 C793 85 02                 sta   mPortRef+2
2052 C795 68                    pla   
2053 C796 85 00                 sta   mPortRef
2054 C798 68                    pla   
2055 C799 85 7E                 sta   mUserID
2056 C79B 68                    pla   
2057 C79C 85 7A                 sta   mWantSize
2058 C79E 68                    pla   
2059 C79F 85 7C                 sta   mBestSize
2060 C7A1              ;
2061 C7A1 6B                    rtl   
2062 C7A2                       ENDP 
2063 C7A2
2064 C7A2
2065 C7A2
2066 C7A2
2067 C7A2
2068 C7A2                       title ' InitScaling' 
2069 C7A2              ****************************************************************
2070 C7A2              *
2071 C7A2              InitScaling PROC 
2072 C7A2              *
2073 C7A2              * This routine inits a bunch of vars to do the scaling.
2074 C7A2              *
2075 C7A2              *
2076 C7A2              * Inputs:
2077 C7A2              *                   ?
2078 C7A2              *
2079 C7A2              * Outputs:
2080 C7A2              *                   ?
2081 C7A2              *
2082 C7A2              * External Refs:
2083 C7A2              *                   none
2084 C7A2              *
2085 C7A2              * Entry Points:
2086 C7A2              *                   none
2087 C7A2              *
2088 C7A2                       longa on                       ; mode
2089 C7A2                       longi on
2090 C7A2              *
2091 C7A2              ****************************************************************
2092 C7A2
2093 C7A2              ;
2094 C7A2 A5 76                 lda   maxB
2095 C7A4 1A                    inc   a
2096 C7A5 1A                    inc   a
2097 C7A6 85 C2                 sta   SrcBufSize
2098 C7A8              ;
2099 C7A8 A5 76                 lda   maxB
2100 C7AA 22 6C C7 FC           jsl   ScaleByte
2101 C7AE 1A                    inc   a
2102 C7AF 1A                    inc   a
2103 C7B0 85 C4                 sta   DstBufSize
2104 C7B2
2105 C7B2
2106 C7B2              * SrcBufSize and DstBufSize are set by the Font Manager before calling
2107 C7B2              * InitScaling.  They include a word of slop on each end for each one
2108 C7B2              * (4 words of slop total).
2109 C7B2
2110 C7B2 A5 C2                 lda   SrcBufSize
2111 C7B4 18                    clc   
2112 C7B5 65 C4                 adc   DstBufSize               ; leave size in A
2113 C7B7              ****************************************************************
2114 C7B7 0A                    asl   a
2115 C7B8 0A                    asl   a
2116 C7B9              ****************************************************************
2117 C7B9
2118 C7B9              * create the new handle
2119 C7B9
2120 C7B9 48                    pha                            ; save size of handle
2121 C7BA
2122 C7BA 48                    pha                            ; function result
2123 C7BB 48                    pha   
2124 C7BC F4 00 00              pea   0                        ; longint size
2125 C7BF 48                    pha   
2126 C7C0 A5 7E 48              Pushword mUserId               ; whatever
2127 C7C3 F4 00 80              pea   $8000                    ; attributes
2128 C7C6 48                    pha                            ; not used (Locinfo)
2129 C7C7 48                    pha   
2130 C7C8 A2 02 09 22           _NewHandle 
2131 C7CF 68                    pla   
2132 C7D0 FA                    plx   
2133 C7D1 85 84                 sta   ScratchHandle
2134 C7D3 86 86                 stx   ScratchHandle+2
2135 C7D5
2136 C7D5 A7 84                 lda   [ScratchHandle]          ; dereference it
2137 C7D7 85 9E                 sta   SrcBuf
2138 C7D9 A0 02 00              ldy   #2
2139 C7DC B7 84                 lda   [ScratchHandle],y
2140 C7DE 85 A0                 sta   SrcBuf+2
2141 C7E0
2142 C7E0 7A                    ply                            ; size of buffer now in Y
2143 C7E1 88                    dey   
2144 C7E2 88                    dey   
2145 C7E3 A9 00 00              lda   #0
2146 C7E6 97 9E        ClearLoop sta   [SrcBuf],y
2147 C7E8 88                    dey   
2148 C7E9 88                    dey   
2149 C7EA 10 FA                 bpl   ClearLoop
2150 C7EC
2151 C7EC A5 C2                 lda   SrcBufSize               ; retrieve src buf len
2152 C7EE              ****************************************************************
2153 C7EE 0A                    asl   a
2154 C7EF              ****************************************************************
2155 C7EF 18                    clc                            ; DstBuf is at end of Scratch
2156 C7F0 65 9E                 adc   SrcBuf
2157 C7F2 85 A2                 sta   DstBuf
2158 C7F4 A5 A0                 lda   SrcBuf+2
2159 C7F6 90 01                 bcc   NBPtr
2160 C7F8 1A                    inc   a
2161 C7F9 85 A4        NBPtr    sta   DstBuf+2
2162 C7FB
2163 C7FB 6B                    rtl   
2164 C7FC
2165 C7FC                       ENDP 
2166 C7FC
2167 C7FC
2168 C7FC                       title ' ScaleBits' 
2169 C7FC              ****************************************************************
2170 C7FC              *
2171 C7FC              ScaleBits PROC 
2172 C7FC              *
2173 C7FC              * Scales the one bit per pixels image.
2174 C7FC              *
2175 C7FC              *
2176 C7FC              * Inputs:
2177 C7FC              *   SrcHSize       Width in pixels of source
2178 C7FC              *   SrcLeft        First pixel to transfer (temp)
2179 C7FC              *   SrcBase        Points to the first byte in the source
2180 C7FC              *                  bit map. (StrikePtr)
2181 C7FC              *   SrcWidth       width in bytes of source bit map. (RowBytes)
2182 C7FC              *
2183 C7FC              *   DstHSize       Width in pixels of destination
2184 C7FC              *   DstLeft        First pixel to transfer (CurrPixel)
2185 C7FC              *   DstBase        Points to the first byte in the destination
2186 C7FC              *                  bit map (nStrikePtr)
2187 C7FC              *   DstWidth       Width in bytes of dest bit map. (newRowBytes)
2188 C7FC              *
2189 C7FC              * Outputs:
2190 C7FC              *                   ?
2191 C7FC              *
2192 C7FC              * External Refs:
2193 C7FC              *                   none
2194 C7FC              *
2195 C7FC              * Entry Points:
2196 C7FC              *                   none
2197 C7FC              *
2198 C7FC                       longa on                       ; mode
2199 C7FC                       longi on
2200 C7FC              *
2201 C7FC              ****************************************************************
2202 C7FC
2203 C7FC A5 6C                 lda   DstHSize
2204 C7FE D0 01                 bne   SomethingLeft
2205 C800 6B                    rtl   
2206 C801
2207 C801              SomethingLeft                           ;
2208 C801
2209 C801              * Save the current dbr here so can set it safely below.
2210 C801 8B                    phb   
2211 C802
2212 C802
2213 C802              * Set the appropriate stretching or shrinking routine.
2214 C802
2215 C802 22 E0 C8 FC           jsl   SetupScaling             ; set Horiz routine
2216 C806
2217 C806              * Initialize our endpoints and counters
2218 C806
2219 C806 64 C6                 stz   DstY
2220 C808              ;
2221 C808              ****  CHANGED TO WORK WITH EVEN BYTE BOUNDARIES THROUGHOUT
2222 C808              ;
2223 C808
2224 C808              * Calculate SrcPtr as SrcBase + bytes(SrcLeft).  We always assume the
2225 C808              * top line of SrcRect matches SrcBase.
2226 C808
2227 C808 A5 44                 lda   SrcLeft
2228 C80A 4A                    lsr   A
2229 C80B 4A                    lsr   A
2230 C80C 4A                    lsr   A
2231 C80D              ;
2232 C80D              ****  MAKE THIS EVEN:
2233 C80D              ;
2234 C80D 29 FE FF              and   #first15Bits
2235 C810              ;
2236 C810              ****  OK
2237 C810              ;
2238 C810 85 88                 sta   SrcLimit                 ;temporary storage
2239 C812              ;
2240 C812 18                    clc   
2241 C813 65 10                 adc   SrcBase
2242 C815 85 A8                 sta   SrcPtr
2243 C817 A5 12                 lda   SrcBase+2
2244 C819 90 01                 bcc   NBSrcBase
2245 C81B 1A                    inc   a
2246 C81C 85 AA        NBSrcBase sta   SrcPtr+2
2247 C81E              ;
2248 C81E A5 44                 lda   srcLeft
2249 C820 18                    clc   
2250 C821 65 6A                 adc   srcHSize
2251 C823 3A                    dec   a
2252 C824 4A                    lsr   a
2253 C825 4A                    lsr   a
2254 C826 4A                    lsr   a
2255 C827 29 FE FF              and   #first15Bits
2256 C82A 38                    sec   
2257 C82B E5 88                 sbc   SrcLimit
2258 C82D 85 BC                 sta   RightPos
2259 C82F 1A                    inc   a
2260 C830 1A                    inc   a
2261 C831 85 88                 sta   SrcLimit                 ;the real thing
2262 C833              ;
2263 C833
2264 C833              * Calculate DstPtr as DstBase + bytes(DstLeft)
2265 C833
2266 C833 A5 68                 lda   DstLeft
2267 C835 4A                    lsr   A
2268 C836 4A                    lsr   A
2269 C837 4A                    lsr   A
2270 C838              ;
2271 C838              ****  MAKE THIS EVEN, TOO:
2272 C838              ;
2273 C838 29 FE FF              and   #first15Bits
2274 C83B              ;
2275 C83B              ****  OK
2276 C83B              ;
2277 C83B 85 8C                 sta   DstLimit                 ;temp storage
2278 C83D              ;
2279 C83D 18                    clc   
2280 C83E
2281 C83E 65 28                 adc   DstBase
2282 C840 85 AC                 sta   DstPtr
2283 C842 A5 2A                 lda   DstBase+2
2284 C844 90 01                 bcc   NBDstBase
2285 C846 1A                    inc   a
2286 C847 85 AE        NBDstBase sta   DstPtr+2
2287 C849
2288 C849 A5 68                 lda   DstLeft
2289 C84B 18                    clc   
2290 C84C 65 6C                 adc   DstHSize
2291 C84E 3A                    dec   a
2292 C84F 4A                    lsr   a
2293 C850 4A                    lsr   a
2294 C851 4A                    lsr   a
2295 C852 29 FE FF              and   #first15Bits
2296 C855 38                    sec   
2297 C856 E5 8C                 sbc   DstLimit
2298 C858 85 C0                 sta   DstRightPos
2299 C85A 1A                    inc   a
2300 C85B 1A                    inc   a
2301 C85C 85 8C                 sta   DstLimit                 ;really & truly
2302 C85E              ;
2303 C85E              ****  END OF CHANGES TO THIS ROUTINE - BHM  x6245  3/20/87
2304 C85E              ;
2305 C85E
2306 C85E              * Set the data bank to the bank containing the dest pixels.
2307 C85E
2308 C85E D4 AD                 pei   DstPtr+1
2309 C860 AB                    plb   
2310 C861 AB                    plb   
2311 C862
2312 C862              * Start the real work in the middle.
2313 C862                        
2314 C862 80 0B                 bra   NBS1
2315 C864
2316 C864              * Get first scanline of Src into SrcBuf
2317 C864
2318 C864 A5 A8        NextSrc  lda   SrcPtr                   ;increment SrcPtr to next scanline
2319 C866 18                    clc   
2320 C867 65 5C                 adc   SrcWidth
2321 C869 85 A8                 sta   SrcPtr
2322 C86B 90 02                 bcc   NBS1
2323 C86D E6 AA                 inc   SrcPtr+2
2324 C86F A4 88        NBS1     ldy   SrcLimit
2325 C871 88                    dey   
2326 C872 88                    dey   
2327 C873 B7 A8        SrcCopyLoop lda   [SrcPtr],y
2328 C875 97 9E                 sta   [SrcBuf],y               ;SrcBuf contains one scanline of source
2329 C877 88                    dey   
2330 C878 88                    dey   
2331 C879 10 F8                 bpl   SrcCopyLoop
2332 C87B A5 80        NextSrc2 lda   VError
2333 C87D 18                    clc   
2334 C87E 65 5A                 adc   DstVSize
2335 C880 85 80                 sta   VError
2336 C882 3A                    dec   a
2337 C883 10 04                 bpl   SrcOk
2338 C885 22 60 C9 FC  MergeIt  jsl   ToMerge
2339 C889              SrcOk                                   ;
2340 C889 A7 9E                 lda   [SrcBuf]                 ; mask the src on left and right
2341 C88B 25 B8                 and   LeftMask
2342 C88D 87 9E                 sta   [SrcBuf]
2343 C88F A4 BC                 ldy   RightPos
2344 C891 B7 9E                 lda   [SrcBuf],y
2345 C893 25 BA                 and   RightMask
2346 C895 97 9E                 sta   [SrcBuf],y
2347 C897 22 84 C9 FC           jsl   ToAction
2348 C89B
2349 C89B A4 C0                 ldy   DstRightPos              ; try masking the right end of
2350 C89D B7 A2                 lda   [DstBuf],y               ; the dest
2351 C89F 25 BE                 and   DstRightMask
2352 C8A1 97 A2                 sta   [DstBuf],y
2353 C8A3
2354 C8A3
2355 C8A3              * we've merged and stretched so now must put result into real
2356 C8A3              * dest buffer.
2357 C8A3
2358 C8A3              NxtMask                                 ;
2359 C8A3 A4 8C                 ldy   DstLimit                 ; move the words.
2360 C8A5 88                    dey   
2361 C8A6 88                    dey   
2362 C8A7 B7 AC        DstCopyLoop lda   [DstPtr],y
2363 C8A9 17 A2                 ora   [DstBuf],y
2364 C8AB 97 AC                 sta   [DstPtr],y
2365 C8AD 88                    dey   
2366 C8AE 88                    dey   
2367 C8AF 10 F6                 bpl   DstCopyLoop
2368 C8B1 A5 AC                 lda   DstPtr                   ;increment DstPtr to next scanline
2369 C8B3 18                    clc   
2370 C8B4 65 5E                 adc   DstWidth
2371 C8B6 85 AC                 sta   DstPtr
2372 C8B8 90 02                 bcc   NBD1
2373 C8BA E6 AE                 inc   DstPtr+2
2374 C8BC A5 C6        NBD1     lda   DstY
2375 C8BE 1A                    inc   a
2376 C8BF C5 5A                 cmp   DstVSize
2377 C8C1 10 0D                 bpl   Done
2378 C8C3 85 C6                 sta   DstY
2379 C8C5 A5 80                 lda   VError
2380 C8C7 38                    sec   
2381 C8C8 E5 4C                 sbc   SrcVSize                 ; subtract increment
2382 C8CA 85 80                 sta   VError                   ; VError := VError - Denom.V
2383 C8CC
2384 C8CC 10 D5                 bpl   NxtMask
2385 C8CE 80 94                 bra   NextSrc
2386 C8D0
2387 C8D0              * Entire Scaling complete. We're still on the first zero page, so use
2388 C8D0              * x to get rid of our scratch buffer, clear the carry, and go home.
2389 C8D0
2390 C8D0 AB           Done     plb                            ; restore bank
2391 C8D1 6B                    rtl   
2392 C8D2                       ENDP 
2393 C8D2
2394 C8D2
2395 C8D2
2396 C8D2                       title ' CleanUpScaling' 
2397 C8D2              ****************************************************************
2398 C8D2              *
2399 C8D2              CleanupScaling PROC 
2400 C8D2              *
2401 C8D2              * Disposes of the ScratchHandle
2402 C8D2              *
2403 C8D2              *
2404 C8D2              * Inputs:
2405 C8D2              *                   ScratchHandle
2406 C8D2              *
2407 C8D2              * Outputs:
2408 C8D2              *                   none
2409 C8D2              *
2410 C8D2              * External Refs:
2411 C8D2              *                   none
2412 C8D2              *
2413 C8D2              * Entry Points:
2414 C8D2              *                   none
2415 C8D2              *
2416 C8D2                       longa on                       ; mode
2417 C8D2                       longi on
2418 C8D2              *
2419 C8D2              ****************************************************************
2420 C8D2
2421 C8D2
2422 C8D2 A5 86 48 A5           PushLong <ScratchHandle 
2423 C8D8 A2 02 10 22           _DisposeHandle 
2424 C8DF
2425 C8DF 6B                    rtl   
2426 C8E0
2427 C8E0                       ENDP 
2428 C8E0
2429 C8E0
2430 C8E0                       title ' SetupScaling' 
2431 C8E0              ****************************************************************
2432 C8E0              *
2433 C8E0              SetupScaling PROC 
2434 C8E0              *
2435 C8E0              * Calc horizontal fraction (if necessary) and case jump
2436 C8E0              *
2437 C8E0              *
2438 C8E0              *
2439 C8E0              * Inputs:
2440 C8E0              *                   ?
2441 C8E0              *
2442 C8E0              * Outputs:
2443 C8E0              *                   ?
2444 C8E0              *
2445 C8E0              * External Refs:
2446 C8E0                       import LMask 
2447 C8E0                       import RMask 
2448 C8E0              *
2449 C8E0              * Entry Points:
2450 C8E0              *                   none
2451 C8E0              *
2452 C8E0                       longa on                       ; mode
2453 C8E0                       longi on
2454 C8E0              *
2455 C8E0              ****************************************************************
2456 C8E0
2457 C8E0
2458 C8E0              * Init error term for DDA
2459 C8E0
2460 C8E0 A5 4C                 lda   SrcVSize                 ; vertical size of source
2461 C8E2 4A                    lsr   A
2462 C8E3 49 FF FF              eor   #$FFFF
2463 C8E6 1A                    inc   a
2464 C8E7 85 80                 sta   VError                   ; VError := -Denom.V/2
2465 C8E9
2466 C8E9              * Now do the rest
2467 C8E9              ;
2468 C8E9              ****  ALTERED TO WORK ON WORD BOUNDARIES:
2469 C8E9              ;
2470 C8E9 A5 44                 lda   SrcLeft                  ; start with left mask
2471 C8EB 29 0F 00              and   #last4Bits
2472 C8EE 0A                    asl   A
2473 C8EF AA                    tax   
2474 C8F0 BF 13 CB FC           lda   >LMask,x
2475 C8F4 85 B8                 sta   LeftMask
2476 C8F6 A5 44                 lda   SrcLeft                  ; now right mask
2477 C8F8 18                    clc   
2478 C8F9 65 6A                 adc   SrcHSize
2479 C8FB 29 0F 00              and   #last4Bits
2480 C8FE
2481 C8FE 0A                    asl   A
2482 C8FF AA                    tax   
2483 C900 BF 33 CB FC           lda   >RMask,x
2484 C904 85 BA                 sta   RightMask
2485 C906              ;
2486 C906              ;
2487 C906              ; Now calculate a dest right mask and dst right pos
2488 C906 A5 68                 lda   DstLeft
2489 C908 18                    clc   
2490 C909 65 6C                 adc   DstHSize
2491 C90B 29 0F 00              and   #last4Bits
2492 C90E
2493 C90E 0A                    asl   A
2494 C90F AA                    tax   
2495 C910 BF 33 CB FC           lda   >RMask,x
2496 C914 85 BE                 sta   DstRightMask
2497 C916              ;
2498 C916              ;
2499 C916 A5 6C                 lda   DstHSize
2500 C918 C5 6A                 cmp   SrcHSize
2501 C91A D0 1F                 bne   NotEqual
2502 C91C A5 68                 lda   DstLeft
2503 C91E 29 0F 00              and   #last4Bits
2504 C921 48                    pha   
2505 C922 A5 44                 lda   SrcLeft
2506 C924 29 0F 00              and   #last4Bits
2507 C927 C3 01                 cmp   1,s
2508 C929 F0 08                 beq   SetCopy
2509 C92B
2510 C92B 68           SetShift pla   
2511 C92C A9 02 00              lda   #ShiftIndex
2512 C92F 85 D8                 sta   ActionIndex
2513 C931 18                    clc   
2514 C932 6B                    rtl   
2515 C933
2516 C933 68           SetCopy  pla   
2517 C934 A9 00 00              lda   #CopyIndex
2518 C937 85 D8                 sta   ActionIndex
2519 C939 18                    clc   
2520 C93A 6B                    rtl   
2521 C93B
2522 C93B 48           NotEqual pha                            ; FixRatio result
2523 C93C 48                    pha   
2524 C93D 30 0B                 bmi   Shrinking
2525 C93F A9 04 00              lda   #StretchIndex
2526 C942 85 D8                 sta   ActionIndex
2527 C944
2528 C944 D4 6A                 pei   SrcHSize                 ; push denominator (Src width)
2529 C946 D4 6C                 pei   DstHSize                 ; push numerator (Dst width)
2530 C948 80 09                 bra   FixRatio
2531 C94A
2532 C94A A9 06 00     Shrinking lda   #ShrinkIndex
2533 C94D 85 D8                 sta   ActionIndex
2534 C94F
2535 C94F D4 6C                 pei   DstHSize
2536 C951 D4 6A                 pei   SrcHSize
2537 C953 A2 0B 0E 22  FixRatio _FixRatio 
2538 C95A 68                    pla                            ; this is the error part
2539 C95B 85 A6                 sta   HInc                     ; which we save
2540 C95D 68                    pla                            ; this better be zero
2541 C95E 18                    clc   
2542 C95F 6B                    rtl   
2543 C960
2544 C960                       ENDP 
2545 C960
2546 C960
2547 C960
2548 C960                       title ' ToMerge' 
2549 C960              ****************************************************************
2550 C960              *
2551 C960              ToMerge  PROC 
2552 C960              *
2553 C960              * ?
2554 C960              *
2555 C960              *
2556 C960              * Inputs:
2557 C960              *                   ?
2558 C960              *
2559 C960              * Outputs:
2560 C960              *                   ?
2561 C960              *
2562 C960              * External Refs:
2563 C960              *                   none
2564 C960              *
2565 C960              * Entry Points:
2566 C960              *                   none
2567 C960              *
2568 C960                       longa on                       ; mode
2569 C960                       longi on
2570 C960              *
2571 C960              ****************************************************************
2572 C960
2573 C960
2574 C960 A5 A8                 lda   SrcPtr                   ; first bump SrcPtr
2575 C962 18                    clc   
2576 C963 65 5C                 adc   SrcWidth
2577 C965 85 A8                 sta   SrcPtr
2578 C967 90 02                 bcc   StartMerging
2579 C969 E6 AA                 inc   SrcPtr+2
2580 C96B A4 88        StartMerging ldy   SrcLimit             ; set up loop
2581 C96D 88                    dey   
2582 C96E 88                    dey   
2583 C96F B7 A8        SrcMerger lda   [SrcPtr],y              ; get the current bits
2584 C971 17 9E                 ora   [SrcBuf],y               ; retain all black (1's)
2585 C973 97 9E                 sta   [SrcBuf],y               ; save the combination
2586 C975 88                    dey   
2587 C976 88                    dey   
2588 C977 10 F6                 bpl   SrcMerger
2589 C979 A5 80                 lda   VError
2590 C97B 18                    clc   
2591 C97C 65 5A                 adc   DstVSize                 ; add destination size
2592 C97E 85 80                 sta   VError                   ; VError := VError + Numer.V
2593 C980 3A                    dec   a
2594 C981 30 DD                 bmi   ToMerge                  ; loop while VError <= 0
2595 C983 6B                    rtl                            ; space keeper
2596 C984
2597 C984
2598 C984                       ENDP 
2599 C984
2600 C984
2601 C984                       title ' ToAction' 
2602 C984              ****************************************************************
2603 C984              *
2604 C984              ToAction PROC 
2605 C984              *
2606 C984              * This is the routine that is called to do the stretching or
2607 C984              * or shrinking.  It uses the ActionIndex to transfer control
2608 C984              * to the appropriate routine.
2609 C984              *
2610 C984              * Inputs:
2611 C984              *                   ActionIndex (on the 3rd direct page)
2612 C984              *
2613 C984              * Outputs:
2614 C984              *                   none
2615 C984              *
2616 C984              * External Refs:
2617 C984                       import CopyText 
2618 C984                       import ShiftText 
2619 C984                       import StretchText 
2620 C984                       import ShrinkText 
2621 C984              *
2622 C984              * Entry Points:
2623 C984              *                   none
2624 C984              *
2625 C984                       longa on                       ; mode
2626 C984                       longi on
2627 C984              *
2628 C984              *
2629 C984              * Change History
2630 C984              *
2631 C984              * 11 Jun 88         Steven Glass
2632 C984              *
2633 C984              * This routine replaces the routine "ToStuff" which used self
2634 C984              * modifying code to accomplish the same purpose.  This change
2635 C984              * makes it possible to run this code in ROM.
2636 C984              *
2637 C984              ****************************************************************
2638 C984
2639 C984 A6 D8                 ldx   ActionIndex
2640 C986 7C 89 C9              jmp   (ActionTable,X)
2641 C989
2642 C989 91 C9        ActionTable DC W:CopyText               ; index is 0
2643 C98B 9E C9                 DC W:ShiftText                 ; index is 2
2644 C98D 98 CA                 DC W:StretchText               ; index is 4
2645 C98F 11 CA                 DC W:ShrinkText                ; index is 6
2646 C991
2647 C991                       ENDP 
2648 C991
2649 C991
2650 C991                       title ' CopyText' 
2651 C991              ****************************************************************
2652 C991              *
2653 C991              CopyText PROC 
2654 C991              *
2655 C991              * We need to establish routines which will either (copy) or
2656 C991              * (copy and shift) from src to destination.
2657 C991              * These already exist.  Use them.
2658 C991              *
2659 C991              *
2660 C991              * Inputs:
2661 C991              *                   none
2662 C991              *
2663 C991              * Outputs:
2664 C991              *                   none
2665 C991              *
2666 C991              * External Refs:
2667 C991              *                   none
2668 C991              *
2669 C991              * Entry Points:
2670 C991              *                   none
2671 C991              *
2672 C991                       longa on                       ; mode
2673 C991                       longi on
2674 C991              *
2675 C991              ****************************************************************
2676 C991
2677 C991
2678 C991 A4 88                 ldy   SrcLimit
2679 C993 88                    dey   
2680 C994 88                    dey   
2681 C995 B7 9E        CopyLoop lda   [SrcBuf],y
2682 C997 97 A2                 sta   [DstBuf],y
2683 C999 88                    dey   
2684 C99A 88                    dey   
2685 C99B 10 F8                 bpl   CopyLoop
2686 C99D 6B                    rtl   
2687 C99E
2688 C99E                       ENDP 
2689 C99E
2690 C99E
2691 C99E
2692 C99E                       title ' ShiftText' 
2693 C99E              ****************************************************************
2694 C99E              *
2695 C99E              ShiftText PROC 
2696 C99E              *
2697 C99E              * This routine takes the bits in the src part of src buffer and
2698 C99E              * moves them to the dst part of dest buffer.
2699 C99E              *
2700 C99E              *
2701 C99E              * Inputs:
2702 C99E              *                   ?
2703 C99E              *
2704 C99E              * Outputs:
2705 C99E              *                   ?
2706 C99E              *
2707 C99E              * External Refs:
2708 C99E              *                   none
2709 C99E              *
2710 C99E              * Entry Points:
2711 C99E              *                   none
2712 C99E              *
2713 C99E                       longa on                       ; mode
2714 C99E                       longi on
2715 C99E              *
2716 C99E              ****************************************************************
2717 C99E
2718 C99E
2719 C99E
2720 C99E 64 B0                 stz   LastOut                  ; start by initializing this var
2721 C9A0 A0 00 00              ldy   #0                       ; index into src and dest buffer
2722 C9A3
2723 C9A3 A5 44                 lda   SrcLeft                  ; look at which bit in byte is
2724 C9A5 29 0F 00              and   #last4Bits               ; first to receive new data
2725 C9A8 48                    pha   
2726 C9A9 A5 68                 lda   DstLeft                  ; look at which bit in byte is
2727 C9AB 29 0F 00              and   #last4Bits               ; first to be transfered
2728 C9AE C3 01                 cmp   1,s                      ; if src is less or equal to
2729 C9B0 B0 35                 bcs   NormalShift              ; dest all is well
2730 C9B2
2731 C9B2 18                    clc   
2732 C9B3 69 10 00              adc   #16
2733 C9B6 38                    sec   
2734 C9B7 E3 01                 sbc   1,s
2735 C9B9 0A                    asl   a
2736 C9BA 85 B6                 sta   HowFarToShift
2737 C9BC 68                    pla   
2738 C9BD
2739 C9BD B7 9E        StaggerLoop lda   [SrcBuf],y
2740 C9BF 85 B4                 sta   ThisWord
2741 C9C1 A6 B6                 ldx   HowFarToShift
2742 C9C3 22 8C 1E E0           jsl   VXShiftOut
2743 C9C7 85 B2                 sta   ThisOut
2744 C9C9 A5 B4                 lda   ThisWord
2745 C9CB A6 B6                 ldx   HowFarToShift
2746 C9CD 22 84 1E E0           jsl   VXShiftStay
2747 C9D1 05 B0                 ora   LastOut
2748 C9D3 88                    dey   
2749 C9D4 88                    dey   
2750 C9D5 30 02                 bmi   SkipThisOne
2751 C9D7 97 A2                 sta   [DstBuf],y
2752 C9D9 A5 B2        SkipThisOne lda   ThisOut
2753 C9DB 85 B0                 sta   LastOut
2754 C9DD C8                    iny                            ; bump by 2
2755 C9DE C8                    iny   
2756 C9DF C4 8C                 cpy   DstLimit                 ; compare to dest limit to see if we
2757 C9E1 10 2D                 bpl   Done                     ; are done
2758 C9E3 C8                    iny                            ; Not yet so bump again to point to
2759 C9E4 C8                    iny                            ; next source
2760 C9E5 80 D6                 bra   StaggerLoop
2761 C9E7
2762 C9E7
2763 C9E7
2764 C9E7
2765 C9E7              NormalShift                             ;
2766 C9E7 38                    sec   
2767 C9E8 E3 01                 sbc   1,s
2768 C9EA 0A                    asl   a
2769 C9EB 85 B6                 sta   HowFarToShift
2770 C9ED
2771 C9ED 68                    pla   
2772 C9EE
2773 C9EE
2774 C9EE B7 9E        ShiftLoop lda   [SrcBuf],y
2775 C9F0 85 B4                 sta   ThisWord
2776 C9F2 A6 B6                 ldx   HowFarToShift
2777 C9F4 22 8C 1E E0           jsl   VXShiftOut
2778 C9F8 85 B2                 sta   ThisOut
2779 C9FA A5 B4                 lda   ThisWord
2780 C9FC A6 B6                 ldx   HowFarToShift
2781 C9FE 22 84 1E E0           jsl   VXShiftStay
2782 CA02 05 B0                 ora   LastOut
2783 CA04 97 A2                 sta   [DstBuf],y
2784 CA06 A5 B2                 lda   ThisOut
2785 CA08 85 B0                 sta   LastOut
2786 CA0A C8                    iny   
2787 CA0B C8                    iny   
2788 CA0C C4 8C                 cpy   DstLimit
2789 CA0E 30 DE                 bmi   ShiftLoop
2790 CA10 6B           Done     rtl   
2791 CA11
2792 CA11                       ENDP 
2793 CA11
2794 CA11                       title ' ShrinkText' 
2795 CA11              ****************************************************************
2796 CA11              *
2797 CA11              ShrinkText PROC 
2798 CA11              *
2799 CA11              * ?
2800 CA11              *
2801 CA11              *
2802 CA11              * Inputs:
2803 CA11              *                   ?
2804 CA11              *
2805 CA11              * Outputs:
2806 CA11              *                   ?
2807 CA11              *
2808 CA11              * External Refs:
2809 CA11              *                   none
2810 CA11              *
2811 CA11              * Entry Points:
2812 CA11              *                   none
2813 CA11              *
2814 CA11                       longa on                       ; mode
2815 CA11                       longi on
2816 CA11              *
2817 CA11              ****************************************************************
2818 CA11
2819 CA11
2820 CA11              ;----------------------------------------------------------
2821 CA11              ;
2822 CA11              ; Initialize DstCnt & DstWord
2823 CA11              ;
2824 CA11 A5 68                 lda   DstLeft                  ; count depends on alignment
2825 CA13 29 0F 00              and   #last4Bits               ; in destination
2826 CA16 49 0F 00              eor   #$000F
2827 CA19 1A                    inc   a
2828 CA1A 85 CA                 sta   DstCnt
2829 CA1C 64 D2                 stz   DstWord                  ; dstword starts as zero
2830 CA1E
2831 CA1E              ;----------------------------------------------------------
2832 CA1E              ;
2833 CA1E              ; Initialize SrcCnt and SrcWord
2834 CA1E              ;
2835 CA1E A5 44                 lda   SrcLeft
2836 CA20 29 0F 00              and   #last4Bits
2837 CA23 AA                    tax   
2838 CA24 49 0F 00              eor   #$000F
2839 CA27 1A                    inc   a
2840 CA28 85 D0                 sta   SrcCnt
2841 CA2A A7 9E                 lda   [SrcBuf]
2842 CA2C EB                    xba   
2843 CA2D E0 00 00              cpx   #0
2844 CA30 F0 04                 beq   SkipThisShit
2845 CA32 0A           againagain asl   a
2846 CA33 CA                    dex   
2847 CA34 D0 FC                 bne   againagain
2848 CA36 85 CE        SkipThisShit sta   SrcWord
2849 CA38
2850 CA38              ;----------------------------------------------------------
2851 CA38              ;
2852 CA38              ; Initialize SrcCtr and DstCtr
2853 CA38              ;
2854 CA38 A0 02 00              ldy   #2
2855 CA3B 84 9C                 sty   SrcCtr
2856 CA3D
2857 CA3D 64 C8                 stz   DstCtr
2858 CA3F
2859 CA3F              ; initialize HError
2860 CA3F 64 82                 stz   HError
2861 CA41
2862 CA41 A5 82        NextX    lda   HError                   ; count how many src pixels go
2863 CA43 A2 00 00              ldx   #0                       ; into one dest pixel
2864 CA46 E8           XLoop    inx   
2865 CA47 18                    clc   
2866 CA48 65 A6                 adc   Hinc
2867 CA4A 90 FA                 bcc   XLoop
2868 CA4C              ;
2869 CA4C              ****  GO FOR IT, MARKS !!!
2870 CA4C              ;
2871 CA4C 85 82                 sta   HError                   ;added 3/23/87 - BHM  x6245
2872 CA4E              ;
2873 CA4E              ****  CROSS YOUR FINGERS . . . .
2874 CA4E              ;
2875 CA4E
2876 CA4E 64 CC                 stz   SrcVal                   ; init num src pixels that are set
2877 CA50 06 CE        NextShift asl   SrcWord                 ; look at next bit in src word
2878 CA52 90 02                 bcc   NBSV                     ; if it is clear dont bump SrcVal
2879 CA54 E6 CC                 inc   SrcVal                   ; bump SrcVal
2880 CA56 C6 D0        NBSV     dec   SrcCnt                   ; are we done with src?
2881 CA58 D0 17                 bne   CntOkay
2882 CA5A
2883 CA5A A9 10 00              lda   #16                      ; get more source word
2884 CA5D 85 D0                 sta   SrcCnt
2885 CA5F A4 9C                 ldy   SrcCtr
2886 CA61              ;
2887 CA61 B7 9E                 lda   [SrcBuf],y
2888 CA63              ;
2889 CA63              ****  ADDED 3/24/87 TO AVOID PICKING UP INVALID SOURCE WORD:
2890 CA63              ;(this isn't the optimal way to make the change, but right
2891 CA63              ;now it's the easiest)
2892 CA63              ;
2893 CA63 C4 88                 cpy   SrcLimit
2894 CA65 30 03                 bmi   SrcWordValid
2895 CA67              ;no, it's not - so feed a 0 in:
2896 CA67 A9 00 00              lda   #0
2897 CA6A              SrcWordValid                            ;
2898 CA6A              ;
2899 CA6A              ****  END OF CHANGE - BHM  x6245
2900 CA6A              ;
2901 CA6A C8                    iny   
2902 CA6B C8                    iny   
2903 CA6C 84 9C                 sty   SrcCtr
2904 CA6E EB                    xba   
2905 CA6F 85 CE                 sta   SrcWord
2906 CA71
2907 CA71 CA           CntOkay  dex                            ; have we collapsed enough bits
2908 CA72 D0 DC                 bne   NextShift
2909 CA74
2910 CA74 A5 CC                 lda   SrcVal                   ; if SrcVal not zero then we want
2911 CA76 C9 01 00              cmp   #1                       ; carry set here
2912 CA79 26 D2                 rol   DstWord                  ; and rotated into dest word
2913 CA7B C6 CA                 dec   DstCnt
2914 CA7D D0 C2                 bne   NextX
2915 CA7F A5 D2                 lda   DstWord
2916 CA81 EB                    xba   
2917 CA82 A4 C8                 ldy   DstCtr
2918 CA84 97 A2                 sta   [DstBuf],y
2919 CA86 C8                    iny   
2920 CA87 C8                    iny   
2921 CA88 84 C8                 sty   DstCtr
2922 CA8A C4 8C                 cpy   DstLimit
2923 CA8C 10 09                 bpl   Done                     ; pray that we really are done
2924 CA8E
2925 CA8E 64 D2                 stz   DstWord
2926 CA90 A9 10 00              lda   #16
2927 CA93 85 CA                 sta   DstCnt
2928 CA95 80 AA                 bra   NextX
2929 CA97
2930 CA97 6B           Done     rtl   
2931 CA98
2932 CA98
2933 CA98                       ENDP 
2934 CA98
2935 CA98
2936 CA98
2937 CA98                       title ' StretchText' 
2938 CA98              ****************************************************************
2939 CA98              *
2940 CA98              StretchText PROC 
2941 CA98              *
2942 CA98              * ?
2943 CA98              *
2944 CA98              *
2945 CA98              * Inputs:
2946 CA98              *                   ?
2947 CA98              *
2948 CA98              * Outputs:
2949 CA98              *                   ?
2950 CA98              *
2951 CA98              * External Refs:
2952 CA98              *                   none
2953 CA98              *
2954 CA98              * Entry Points:
2955 CA98              *                   none
2956 CA98              *
2957 CA98                       longa on                       ; mode
2958 CA98                       longi on
2959 CA98              *
2960 CA98              ****************************************************************
2961 CA98
2962 CA98
2963 CA98              ;----------------------------------------------------------
2964 CA98              ;
2965 CA98              ; Initialize DstCnt & DstWord
2966 CA98              ;
2967 CA98 A5 68                 lda   DstLeft                  ; count depends on alignment
2968 CA9A 29 0F 00              and   #last4Bits               ; in destination
2969 CA9D 49 0F 00              eor   #$000F
2970 CAA0 1A                    inc   a
2971 CAA1 85 CA                 sta   DstCnt
2972 CAA3 64 D2                 stz   DstWord                  ; dstword starts as zero
2973 CAA5
2974 CAA5              ;----------------------------------------------------------
2975 CAA5              ;
2976 CAA5              ; Initialize SrcCnt and SrcWord
2977 CAA5              ;
2978 CAA5 A5 44                 lda   SrcLeft
2979 CAA7 29 0F 00              and   #last4Bits
2980 CAAA AA                    tax   
2981 CAAB 49 0F 00              eor   #$000F
2982 CAAE 1A                    inc   a
2983 CAAF 85 D0                 sta   SrcCnt
2984 CAB1 A7 9E                 lda   [SrcBuf]
2985 CAB3 EB                    xba   
2986 CAB4 E0 00 00              cpx   #0
2987 CAB7 F0 04                 beq   SkipThisShit
2988 CAB9 0A           againagain asl   a
2989 CABA CA                    dex   
2990 CABB D0 FC                 bne   againagain
2991 CABD 85 CE        SkipThisShit sta   SrcWord
2992 CABF
2993 CABF              ;----------------------------------------------------------
2994 CABF              ;
2995 CABF              ; Initialize SrcCtr and DstCtr
2996 CABF              ;
2997 CABF A0 02 00              ldy   #2
2998 CAC2 84 9C                 sty   SrcCtr
2999 CAC4
3000 CAC4 64 C8                 stz   DstCtr
3001 CAC6
3002 CAC6              ; initialize HError
3003 CAC6 64 82                 stz   HError
3004 CAC8
3005 CAC8              ;----------------------------------------------------------
3006 CAC8              ;
3007 CAC8              ;
3008 CAC8
3009 CAC8
3010 CAC8 08                    php                            ; put this on stack to make things even
3011 CAC9 A2 00 00     NextX    ldx   #0                       ; Count Dst pixels
3012 CACC A5 82                 lda   HError
3013 CACE E8           XLoop    inx   
3014 CACF 18                    clc   
3015 CAD0 65 A6                 adc   HInc
3016 CAD2 90 FA                 bcc   XLoop
3017 CAD4 85 82                 sta   Herror
3018 CAD6
3019 CAD6 28                    plp                            ; get this off stack
3020 CAD7 06 CE                 asl   SrcWord                  ; set carry from src word
3021 CAD9 08                    php                            ; put back on stack
3022 CADA C6 D0                 dec   SrcCnt                   ; are we done with this src word
3023 CADC D0 10                 bne   RotateX                  ; no, rotate it in
3024 CADE A9 10 00              lda   #16                      ; yes start next one
3025 CAE1 85 D0                 sta   SrcCnt
3026 CAE3
3027 CAE3 A4 9C                 ldy   SrcCtr                   ; get next src word from buffer
3028 CAE5 B7 9E                 lda   [SrcBuf],y
3029 CAE7 C8                    iny   
3030 CAE8 C8                    iny   
3031 CAE9 84 9C                 sty   SrcCtr
3032 CAEB EB                    xba   
3033 CAEC 85 CE                 sta   SrcWord
3034 CAEE 28           RotateX  plp                            ; now roll that last carry into
3035 CAEF 08                    php                            ; the current dest word as many times
3036 CAF0 26 D2                 rol   DstWord                  ; as required by x
3037 CAF2 C6 CA                 dec   DstCnt
3038 CAF4 D0 16                 bne   NotEmpty
3039 CAF6 A5 D2                 lda   DstWord
3040 CAF8 EB                    xba   
3041 CAF9 A4 C8                 ldy   DstCtr
3042 CAFB 97 A2                 sta   [DstBuf],y
3043 CAFD C8                    iny   
3044 CAFE C8                    iny   
3045 CAFF 84 C8                 sty   DstCtr
3046 CB01
3047 CB01 C4 8C                 cpy   DstLimit
3048 CB03 10 0C                 bpl   Done
3049 CB05
3050 CB05 64 D2                 stz   DstWord                  ; set up for next pass
3051 CB07 A9 10 00              lda   #16
3052 CB0A 85 CA                 sta   DstCnt
3053 CB0C
3054 CB0C CA           NotEmpty dex   
3055 CB0D D0 DF                 bne   RotateX
3056 CB0F 80 B8                 bra   NextX
3057 CB11
3058 CB11 28           Done     plp   
3059 CB12 6B                    rtl   
3060 CB13
3061 CB13                       ENDP 
3062 CB13
3063 CB13
3064 CB13                       title ' LMask and RMask' 
3065 CB13              **********************************************************************
3066 CB13              *
3067 CB13              * Mask Tables
3068 CB13              *
3069 CB13              **********************************************************************
3070 CB13              LMask    PROC 
3071 CB13 FF FF                 DC B:%11111111,%11111111
3072 CB15 7F FF                 DC B:%01111111,%11111111
3073 CB17 3F FF                 DC B:%00111111,%11111111
3074 CB19 1F FF                 DC B:%00011111,%11111111
3075 CB1B 0F FF                 DC B:%00001111,%11111111
3076 CB1D 07 FF                 DC B:%00000111,%11111111
3077 CB1F 03 FF                 DC B:%00000011,%11111111
3078 CB21 01 FF                 DC B:%00000001,%11111111
3079 CB23 00 FF                 DC B:%00000000,%11111111
3080 CB25 00 7F                 DC B:%00000000,%01111111
3081 CB27 00 3F                 DC B:%00000000,%00111111
3082 CB29 00 1F                 DC B:%00000000,%00011111
3083 CB2B 00 0F                 DC B:%00000000,%00001111
3084 CB2D 00 07                 DC B:%00000000,%00000111
3085 CB2F 00 03                 DC B:%00000000,%00000011
3086 CB31 00 01                 DC B:%00000000,%00000001
3087 CB33                       ENDP 
3088 CB33
3089 CB33              RMask    PROC 
3090 CB33 FF FF                 DC B:%11111111,%11111111
3091 CB35 80 00                 DC B:%10000000,%00000000
3092 CB37 C0 00                 DC B:%11000000,%00000000
3093 CB39 E0 00                 DC B:%11100000,%00000000
3094 CB3B F0 00                 DC B:%11110000,%00000000
3095 CB3D F8 00                 DC B:%11111000,%00000000
3096 CB3F FC 00                 DC B:%11111100,%00000000
3097 CB41 FE 00                 DC B:%11111110,%00000000
3098 CB43 FF 00                 DC B:%11111111,%00000000
3099 CB45 FF 80                 DC B:%11111111,%10000000
3100 CB47 FF C0                 DC B:%11111111,%11000000
3101 CB49 FF E0                 DC B:%11111111,%11100000
3102 CB4B FF F0                 DC B:%11111111,%11110000
3103 CB4D FF F8                 DC B:%11111111,%11111000
3104 CB4F FF FC                 DC B:%11111111,%11111100
3105 CB51 FF FE                 DC B:%11111111,%11111110
3106 CB53                       ENDP 
3107 CB53
3108 CB53
3109 CB53
3110 CB53
3111 CB53
3112 CB53
3113 CB53                       END   
3114 CB53
